package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.inbox.InboxDatasource;

/**
 * isSingleton = true
 */
public final class InboxDatasourceProvider {
  @NonNull
  public static final InboxDatasource get(Context context) {
    InboxDatasource instance = DI.getInstance().getSingletonInstance(InboxDatasource.class);
    if (instance != null) {
      return instance;
    }
    instance = new InboxDatasource(context);
    DI.getInstance().addSingletonInstance(InboxDatasource.class, instance);
    return instance;
  }

  @Nullable
  public static final InboxDatasource getSingleton() {
    return DI.getInstance().getSingletonInstance(InboxDatasource.class);
  }
}
