package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.WebserviceMetrics;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class WebserviceMetricsProvider {
  @NonNull
  public static final WebserviceMetrics get() {
    WebserviceMetrics instance = DI.getInstance().getSingletonInstance(WebserviceMetrics.class);
    if (instance != null) {
      return instance;
    }
    instance = new WebserviceMetrics();
    DI.getInstance().addSingletonInstance(WebserviceMetrics.class, instance);
    return instance;
  }

  @Nullable
  public static final WebserviceMetrics getSingleton() {
    return DI.getInstance().getSingletonInstance(WebserviceMetrics.class);
  }
}
