package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.PushModule;

/**
 * isSingleton = true
 */
public final class PushModuleProvider {
  @NonNull
  public static final PushModule get() {
    PushModule instance = DI.getInstance().getSingletonInstance(PushModule.class);
    if (instance != null) {
      return instance;
    }
    instance = PushModule.provide();
    DI.getInstance().addSingletonInstance(PushModule.class, instance);
    return instance;
  }

  @Nullable
  public static final PushModule getSingleton() {
    return DI.getInstance().getSingletonInstance(PushModule.class);
  }
}
