package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.MessagingModule;

/**
 * isSingleton = true
 */
public final class MessagingModuleProvider {
  @NonNull
  public static final MessagingModule get() {
    MessagingModule instance = DI.getInstance().getSingletonInstance(MessagingModule.class);
    if (instance != null) {
      return instance;
    }
    instance = MessagingModule.provide();
    DI.getInstance().addSingletonInstance(MessagingModule.class, instance);
    return instance;
  }

  @Nullable
  public static final MessagingModule getSingleton() {
    return DI.getInstance().getSingletonInstance(MessagingModule.class);
  }
}
