package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.DisplayReceiptModule;

/**
 * isSingleton = true
 */
public final class DisplayReceiptModuleProvider {
  @NonNull
  public static final DisplayReceiptModule get() {
    DisplayReceiptModule instance = DI.getInstance().getSingletonInstance(DisplayReceiptModule.class);
    if (instance != null) {
      return instance;
    }
    instance = DisplayReceiptModule.provide();
    DI.getInstance().addSingletonInstance(DisplayReceiptModule.class, instance);
    return instance;
  }

  @Nullable
  public static final DisplayReceiptModule getSingleton() {
    return DI.getInstance().getSingletonInstance(DisplayReceiptModule.class);
  }
}
