package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.BatchModuleMaster;

/**
 * isSingleton = true
 */
public final class BatchModuleMasterProvider {
  @NonNull
  public static final BatchModuleMaster get() {
    BatchModuleMaster instance = DI.getInstance().getSingletonInstance(BatchModuleMaster.class);
    if (instance != null) {
      return instance;
    }
    instance = BatchModuleMaster.provide();
    DI.getInstance().addSingletonInstance(BatchModuleMaster.class, instance);
    return instance;
  }

  @Nullable
  public static final BatchModuleMaster getSingleton() {
    return DI.getInstance().getSingletonInstance(BatchModuleMaster.class);
  }
}
