package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.AdvertisingID;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class AdvertisingIDProvider {
  @NonNull
  public static final AdvertisingID get() {
    AdvertisingID instance = DI.getInstance().getSingletonInstance(AdvertisingID.class);
    if (instance != null) {
      return instance;
    }
    instance = new AdvertisingID();
    DI.getInstance().addSingletonInstance(AdvertisingID.class, instance);
    return instance;
  }

  @Nullable
  public static final AdvertisingID getSingleton() {
    return DI.getInstance().getSingletonInstance(AdvertisingID.class);
  }
}
