package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.TrackerModule;

/**
 * isSingleton = true
 */
public final class TrackerModuleProvider {
  @NonNull
  public static final TrackerModule get() {
    TrackerModule instance = DI.getInstance().getSingletonInstance(TrackerModule.class);
    if (instance != null) {
      return instance;
    }
    instance = TrackerModule.provide();
    DI.getInstance().addSingletonInstance(TrackerModule.class, instance);
    return instance;
  }

  @Nullable
  public static final TrackerModule getSingleton() {
    return DI.getInstance().getSingletonInstance(TrackerModule.class);
  }
}
