package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.user.SQLUserDatasource;

/**
 * isSingleton = true
 */
public final class SQLUserDatasourceProvider {
  @NonNull
  public static final SQLUserDatasource get(Context context) {
    SQLUserDatasource instance = DI.getInstance().getSingletonInstance(SQLUserDatasource.class);
    if (instance != null) {
      return instance;
    }
    instance = new SQLUserDatasource(context);
    DI.getInstance().addSingletonInstance(SQLUserDatasource.class, instance);
    return instance;
  }

  @Nullable
  public static final SQLUserDatasource getSingleton() {
    return DI.getInstance().getSingletonInstance(SQLUserDatasource.class);
  }
}
