/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import com.batch.android.json.JSONStringer;
import com.batch.android.json.JSONTokener;
import com.batch.android.json.a;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JSONArray {
    private final List<Object> a;

    public JSONArray() {
        this.a = new ArrayList<Object>();
    }

    public JSONArray(Collection copyFrom) {
        this();
        if (copyFrom != null) {
            Iterator iterator = copyFrom.iterator();
            while (iterator.hasNext()) {
                this.put(JSONObject.wrap(iterator.next()));
            }
        }
    }

    public JSONArray(JSONTokener readFrom) throws JSONException {
        Object object = readFrom.nextValue();
        if (!(object instanceof JSONArray)) {
            throw com.batch.android.json.a.a(object, "JSONArray");
        }
        this.a = ((JSONArray)object).a;
    }

    public JSONArray(String json) throws JSONException {
        this(new JSONTokener(json));
    }

    public JSONArray(Object array) throws JSONException {
        if (!array.getClass().isArray()) {
            throw new JSONException("Not a primitive array: " + array.getClass());
        }
        int n2 = Array.getLength(array);
        this.a = new ArrayList<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(JSONObject.wrap(Array.get(array, i2)));
        }
    }

    public int length() {
        return this.a.size();
    }

    public JSONArray put(boolean value) {
        this.a.add(value);
        return this;
    }

    public JSONArray put(double value) throws JSONException {
        this.a.add(com.batch.android.json.a.a(value));
        return this;
    }

    public JSONArray put(int value) {
        this.a.add(value);
        return this;
    }

    public JSONArray put(long value) {
        this.a.add(value);
        return this;
    }

    public JSONArray put(Object value) {
        this.a.add(value);
        return this;
    }

    void a(Object object) throws JSONException {
        if (object instanceof Number) {
            com.batch.android.json.a.a(((Number)object).doubleValue());
        }
        this.put(object);
    }

    public JSONArray put(int index, boolean value) throws JSONException {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, double value) throws JSONException {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, int value) throws JSONException {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, long value) throws JSONException {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, Object value) throws JSONException {
        if (value instanceof Number) {
            com.batch.android.json.a.a(((Number)value).doubleValue());
        }
        while (this.a.size() <= index) {
            this.a.add(null);
        }
        this.a.set(index, value);
        return this;
    }

    public boolean isNull(int index) {
        Object object = this.opt(index);
        return object == null || object == JSONObject.NULL;
    }

    public Object get(int index) throws JSONException {
        try {
            Object object = this.a.get(index);
            if (object == null) {
                throw new JSONException("Value at " + index + " is null.");
            }
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JSONException("Index " + index + " out of range [0.." + this.a.size() + ")");
        }
    }

    public Object opt(int index) {
        if (index < 0 || index >= this.a.size()) {
            return null;
        }
        return this.a.get(index);
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.a.size()) {
            return null;
        }
        return this.a.remove(index);
    }

    public boolean getBoolean(int index) throws JSONException {
        Object object = this.get(index);
        Boolean bl = com.batch.android.json.a.a(object);
        if (bl == null) {
            throw com.batch.android.json.a.a(index, object, "boolean");
        }
        return bl;
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean fallback) {
        Object object = this.opt(index);
        Boolean bl = com.batch.android.json.a.a(object);
        return bl != null ? bl : fallback;
    }

    public double getDouble(int index) throws JSONException {
        Object object = this.get(index);
        Double d2 = com.batch.android.json.a.b(object);
        if (d2 == null) {
            throw com.batch.android.json.a.a(index, object, "double");
        }
        return d2;
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double fallback) {
        Object object = this.opt(index);
        Double d2 = com.batch.android.json.a.b(object);
        return d2 != null ? d2 : fallback;
    }

    public int getInt(int index) throws JSONException {
        Object object = this.get(index);
        Integer n2 = com.batch.android.json.a.c(object);
        if (n2 == null) {
            throw com.batch.android.json.a.a(index, object, "int");
        }
        return n2;
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int fallback) {
        Object object = this.opt(index);
        Integer n2 = com.batch.android.json.a.c(object);
        return n2 != null ? n2 : fallback;
    }

    public long getLong(int index) throws JSONException {
        Object object = this.get(index);
        Long l2 = com.batch.android.json.a.d(object);
        if (l2 == null) {
            throw com.batch.android.json.a.a(index, object, "long");
        }
        return l2;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long fallback) {
        Object object = this.opt(index);
        Long l2 = com.batch.android.json.a.d(object);
        return l2 != null ? l2 : fallback;
    }

    public String getString(int index) throws JSONException {
        Object object = this.get(index);
        String string2 = com.batch.android.json.a.e(object);
        if (string2 == null) {
            throw com.batch.android.json.a.a(index, object, "String");
        }
        return string2;
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String fallback) {
        Object object = this.opt(index);
        String string2 = com.batch.android.json.a.e(object);
        return string2 != null ? string2 : fallback;
    }

    public JSONArray getJSONArray(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw com.batch.android.json.a.a(index, object, "JSONArray");
    }

    public JSONArray optJSONArray(int index) {
        Object object = this.opt(index);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject getJSONObject(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw com.batch.android.json.a.a(index, object, "JSONObject");
    }

    public JSONObject optJSONObject(int index) {
        Object object = this.opt(index);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n2 = Math.min(names.length(), this.a.size());
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = com.batch.android.json.a.e(names.opt(i2));
            jSONObject.put(string2, this.opt(i2));
        }
        return jSONObject;
    }

    public String join(String separator) throws JSONException {
        JSONStringer jSONStringer = new JSONStringer();
        jSONStringer.a(JSONStringer.a.f, "");
        int n2 = this.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                jSONStringer.a.append(separator);
            }
            jSONStringer.value(this.a.get(i2));
        }
        jSONStringer.a(JSONStringer.a.f, JSONStringer.a.f, "");
        return jSONStringer.a.toString();
    }

    public String toString() {
        try {
            JSONStringer jSONStringer = new JSONStringer();
            this.a(jSONStringer);
            return jSONStringer.toString();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public String toString(int indentSpaces) throws JSONException {
        JSONStringer jSONStringer = new JSONStringer(indentSpaces);
        this.a(jSONStringer);
        return jSONStringer.toString();
    }

    void a(JSONStringer jSONStringer) throws JSONException {
        jSONStringer.array();
        for (Object object : this.a) {
            jSONStringer.value(object);
        }
        jSONStringer.endArray();
    }

    public boolean equals(Object o2) {
        return o2 instanceof JSONArray && ((JSONArray)o2).a.equals(this.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }
}

