/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import com.batch.android.BatchPushPayload;
import com.batch.android.a.a;
import com.batch.android.c.u;
import com.batch.android.j.l;

@a
public final class BatchNotificationChannelsManager {
    public static final String DEFAULT_CHANNEL_ID = "_BATCHSDK_DEFAULT";
    @Nullable
    private String a = null;
    @Nullable
    private ChannelNameProvider b = null;
    @Nullable
    private NotificationChannelIdInterceptor c = null;

    private boolean b() {
        return this.a == null;
    }

    public static boolean openSystemChannelSettings(@NonNull Context context) {
        return BatchNotificationChannelsManager.openSystemChannelSettings(context, DEFAULT_CHANNEL_ID);
    }

    public static boolean openSystemChannelSettings(@NonNull Context context, @NonNull String string) {
        if (context != null) {
            if (string != null) {
                if (Build.VERSION.SDK_INT >= 26) {
                    Context context2;
                    try {
                        context2 = context;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                    Intent intent = new Intent("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                    intent.putExtra("android.provider.extra.CHANNEL_ID", string);
                    intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                    context2.startActivity(intent);
                    return true;
                }
                return false;
            }
            throw new IllegalArgumentException("ChannelId is mandatory");
        }
        throw new IllegalArgumentException("Context is mandatory");
    }

    @NonNull
    String a(BatchPushPayload batchPushPayload) {
        block5: {
            Object object;
            String string;
            block4: {
                String string2 = DEFAULT_CHANNEL_ID;
                string = ((BatchNotificationChannelsManager)object).a;
                if (string == null) {
                    string = string2;
                }
                object = ((BatchNotificationChannelsManager)object).c;
                if (object != null) {
                    try {
                        object = object.getChannelId(batchPushPayload, string);
                        if (object == null) break block4;
                        break block5;
                    }
                    catch (Exception exception) {
                        u.b(false, "Batch.Push: An exception occurred while calling the specified channel id interceptor. Falling back on '" + string + "'", (Throwable)exception);
                    }
                }
            }
            object = string;
        }
        return object;
    }

    void a(Context context) {
        if (Build.VERSION.SDK_INT >= 26 && batchNotificationChannelsManager.b()) {
            NotificationChannel notificationChannel;
            u.a("Registering default Batch notification channel");
            NotificationChannel notificationChannel2 = notificationChannel;
            new NotificationChannel(DEFAULT_CHANNEL_ID, (CharSequence)batchNotificationChannelsManager.a(), 3).setShowBadge(true);
            notificationChannel2.enableLights(true);
            notificationChannel2.enableVibration(true);
            BatchNotificationChannelsManager batchNotificationChannelsManager = l.n().r();
            if (batchNotificationChannelsManager != null) {
                notificationChannel2.setSound((Uri)batchNotificationChannelsManager, new AudioAttributes.Builder().setUsage(5).build());
            }
            ((NotificationManager)context.getSystemService(NotificationManager.class)).createNotificationChannel(notificationChannel2);
        }
    }

    String a() {
        Object object;
        block4: {
            BatchNotificationChannelsManager batchNotificationChannelsManager = batchNotificationChannelsManager2;
            BatchNotificationChannelsManager batchNotificationChannelsManager2 = null;
            object = batchNotificationChannelsManager.b;
            if (object != null) {
                try {
                    object = object.getDefaultChannelName();
                    break block4;
                }
                catch (Exception exception) {
                    u.b(false, "Batch.Push: An exception occurred while calling the specified channel id interceptor. Falling back on the default name.", (Throwable)exception);
                }
            }
            object = batchNotificationChannelsManager2;
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = "Notifications";
        }
        return object;
    }

    public void setChannelIdOverride(@Nullable String string) {
        this.a = string;
    }

    public void setChannelNameProvider(@Nullable ChannelNameProvider channelNameProvider) {
        this.b = channelNameProvider;
    }

    public void setChannelName(@NonNull Context context, @StringRes int n2) {
        this.setChannelNameProvider(new StringResChannelNameProvider(context, n2));
    }

    public void setChannelIdInterceptor(@Nullable NotificationChannelIdInterceptor notificationChannelIdInterceptor) {
        this.c = notificationChannelIdInterceptor;
    }

    @a
    public static interface NotificationChannelIdInterceptor {
        @Nullable
        public String getChannelId(@NonNull BatchPushPayload var1, String var2);
    }

    @a
    public static final class StringResChannelNameProvider
    implements ChannelNameProvider {
        private Context a;
        private int b;

        public StringResChannelNameProvider(@NonNull Context context, @StringRes int n2) {
            this.a = context.getApplicationContext();
            this.b = n2;
        }

        @Override
        @NonNull
        public String getDefaultChannelName() {
            return this.a.getResources().getString(this.b);
        }
    }

    @a
    public static interface ChannelNameProvider {
        @NonNull
        public String getDefaultChannelName();
    }
}

