/*
 * Decompiled with CFR 0.152.
 */
package com.balysv.materialripple;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import com.balysv.materialripple.R;

public class MaterialRippleLayout
extends FrameLayout {
    private static final int DEFAULT_DURATION = 350;
    private static final int DEFAULT_FADE_DURATION = 75;
    private static final float DEFAULT_DIAMETER_DP = 35.0f;
    private static final float DEFAULT_ALPHA = 0.2f;
    private static final int DEFAULT_COLOR = -16777216;
    private static final int DEFAULT_BACKGROUND = 0;
    private static final boolean DEFAULT_HOVER = true;
    private static final boolean DEFAULT_DELAY_CLICK = true;
    private static final boolean DEFAULT_PERSISTENT = false;
    private static final boolean DEFAULT_SEARCH_ADAPTER = false;
    private static final boolean DEFAULT_RIPPLE_OVERLAY = false;
    private static final int DEFAULT_ROUNDED_CORNERS = 0;
    private static final int FADE_EXTRA_DELAY = 50;
    private static final long HOVER_DURATION = 2500L;
    private final Paint paint = new Paint(1);
    private final Rect bounds = new Rect();
    private int rippleColor;
    private boolean rippleOverlay;
    private boolean rippleHover;
    private int rippleDiameter;
    private int rippleDuration;
    private int rippleAlpha;
    private boolean rippleDelayClick;
    private int rippleFadeDuration;
    private boolean ripplePersistent;
    private Drawable rippleBackground;
    private boolean rippleInAdapter;
    private float rippleRoundedCorners;
    private float radius;
    private AdapterView parentAdapter;
    private View childView;
    private AnimatorSet rippleAnimator;
    private ObjectAnimator hoverAnimator;
    private Point currentCoords = new Point();
    private Point previousCoords = new Point();
    private int layerType;
    private boolean eventCancelled;
    private boolean prepressed;
    private int positionInAdapter;
    private GestureDetector gestureDetector;
    private PerformClickEvent pendingClickEvent;
    private PressedEvent pendingPressEvent;
    private boolean mHasPerformedLongPress;
    private GestureDetector.SimpleOnGestureListener longClickListener = new GestureDetector.SimpleOnGestureListener(){

        public void onLongPress(MotionEvent e) {
            MaterialRippleLayout.this.mHasPerformedLongPress = MaterialRippleLayout.this.childView.performLongClick();
            if (MaterialRippleLayout.this.mHasPerformedLongPress) {
                if (MaterialRippleLayout.this.rippleHover) {
                    MaterialRippleLayout.this.startRipple(null);
                }
                MaterialRippleLayout.this.cancelPressedEvent();
            }
        }

        public boolean onDown(MotionEvent e) {
            MaterialRippleLayout.this.mHasPerformedLongPress = false;
            return super.onDown(e);
        }
    };
    private Property<MaterialRippleLayout, Float> radiusProperty = new Property<MaterialRippleLayout, Float>(Float.class, "radius"){

        public Float get(MaterialRippleLayout object) {
            return Float.valueOf(object.getRadius());
        }

        public void set(MaterialRippleLayout object, Float value) {
            object.setRadius(value.floatValue());
        }
    };
    private Property<MaterialRippleLayout, Integer> circleAlphaProperty = new Property<MaterialRippleLayout, Integer>(Integer.class, "rippleAlpha"){

        public Integer get(MaterialRippleLayout object) {
            return object.getRippleAlpha();
        }

        public void set(MaterialRippleLayout object, Integer value) {
            object.setRippleAlpha(value);
        }
    };

    public static RippleBuilder on(View view) {
        return new RippleBuilder(view);
    }

    public MaterialRippleLayout(Context context) {
        this(context, null, 0);
    }

    public MaterialRippleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialRippleLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.longClickListener);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MaterialRippleLayout);
        this.rippleColor = a.getColor(R.styleable.MaterialRippleLayout_rippleColor, -16777216);
        this.rippleDiameter = a.getDimensionPixelSize(R.styleable.MaterialRippleLayout_rippleDimension, (int)MaterialRippleLayout.dpToPx(this.getResources(), 35.0f));
        this.rippleOverlay = a.getBoolean(R.styleable.MaterialRippleLayout_rippleOverlay, false);
        this.rippleHover = a.getBoolean(R.styleable.MaterialRippleLayout_rippleHover, true);
        this.rippleDuration = a.getInt(R.styleable.MaterialRippleLayout_rippleDuration, 350);
        this.rippleAlpha = (int)(255.0f * a.getFloat(R.styleable.MaterialRippleLayout_rippleAlpha, 0.2f));
        this.rippleDelayClick = a.getBoolean(R.styleable.MaterialRippleLayout_rippleDelayClick, true);
        this.rippleFadeDuration = a.getInteger(R.styleable.MaterialRippleLayout_rippleFadeDuration, 75);
        this.rippleBackground = new ColorDrawable(a.getColor(R.styleable.MaterialRippleLayout_rippleBackground, 0));
        this.ripplePersistent = a.getBoolean(R.styleable.MaterialRippleLayout_ripplePersistent, false);
        this.rippleInAdapter = a.getBoolean(R.styleable.MaterialRippleLayout_rippleInAdapter, false);
        this.rippleRoundedCorners = a.getDimensionPixelSize(R.styleable.MaterialRippleLayout_rippleRoundedCorners, 0);
        a.recycle();
        this.paint.setColor(this.rippleColor);
        this.paint.setAlpha(this.rippleAlpha);
        this.enableClipPathSupportIfNecessary();
    }

    public <T extends View> T getChildView() {
        return (T)this.childView;
    }

    public final void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("MaterialRippleLayout can host only one child");
        }
        this.childView = child;
        super.addView(child, index, params);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        if (this.childView == null) {
            throw new IllegalStateException("MaterialRippleLayout must have a child view to handle clicks");
        }
        this.childView.setOnClickListener(onClickListener);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return !this.findClickableViewInChild(this.childView, (int)event.getX(), (int)event.getY());
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean gestureResult;
        boolean superOnTouchEvent = super.onTouchEvent(event);
        if (!this.isEnabled() || !this.childView.isEnabled()) {
            return superOnTouchEvent;
        }
        boolean isEventInBounds = this.bounds.contains((int)event.getX(), (int)event.getY());
        if (isEventInBounds) {
            this.previousCoords.set(this.currentCoords.x, this.currentCoords.y);
            this.currentCoords.set((int)event.getX(), (int)event.getY());
        }
        if ((gestureResult = this.gestureDetector.onTouchEvent(event)) || this.mHasPerformedLongPress) {
            return true;
        }
        int action = event.getActionMasked();
        switch (action) {
            case 1: {
                this.pendingClickEvent = new PerformClickEvent();
                if (this.prepressed) {
                    this.childView.setPressed(true);
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            MaterialRippleLayout.this.childView.setPressed(false);
                        }
                    }, ViewConfiguration.getPressedStateDuration());
                }
                if (isEventInBounds) {
                    this.startRipple(this.pendingClickEvent);
                } else if (!this.rippleHover) {
                    this.setRadius(0.0f);
                }
                if (!this.rippleDelayClick && isEventInBounds) {
                    this.pendingClickEvent.run();
                }
                this.cancelPressedEvent();
                break;
            }
            case 0: {
                this.setPositionInAdapter();
                this.eventCancelled = false;
                this.pendingPressEvent = new PressedEvent(event);
                if (this.isInScrollingContainer()) {
                    this.cancelPressedEvent();
                    this.prepressed = true;
                    this.postDelayed(this.pendingPressEvent, ViewConfiguration.getTapTimeout());
                    break;
                }
                this.pendingPressEvent.run();
                break;
            }
            case 3: {
                if (this.rippleInAdapter) {
                    this.currentCoords.set(this.previousCoords.x, this.previousCoords.y);
                    this.previousCoords = new Point();
                }
                this.childView.onTouchEvent(event);
                if (this.rippleHover) {
                    if (!this.prepressed) {
                        this.startRipple(null);
                    }
                } else {
                    this.childView.setPressed(false);
                }
                this.cancelPressedEvent();
                break;
            }
            case 2: {
                if (this.rippleHover) {
                    if (isEventInBounds && !this.eventCancelled) {
                        this.invalidate();
                    } else if (!isEventInBounds) {
                        this.startRipple(null);
                    }
                }
                if (isEventInBounds) break;
                this.cancelPressedEvent();
                if (this.hoverAnimator != null) {
                    this.hoverAnimator.cancel();
                }
                this.childView.onTouchEvent(event);
                this.eventCancelled = true;
            }
        }
        return true;
    }

    private void cancelPressedEvent() {
        if (this.pendingPressEvent != null) {
            this.removeCallbacks(this.pendingPressEvent);
            this.prepressed = false;
        }
    }

    private void startHover() {
        if (this.eventCancelled) {
            return;
        }
        if (this.hoverAnimator != null) {
            this.hoverAnimator.cancel();
        }
        float radius = (float)(Math.sqrt(Math.pow(this.getWidth(), 2.0) + Math.pow(this.getHeight(), 2.0)) * (double)1.2f);
        this.hoverAnimator = ObjectAnimator.ofFloat((Object)((Object)this), this.radiusProperty, (float[])new float[]{this.rippleDiameter, radius}).setDuration(2500L);
        this.hoverAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.hoverAnimator.start();
    }

    private void startRipple(final Runnable animationEndRunnable) {
        if (this.eventCancelled) {
            return;
        }
        float endRadius = this.getEndRadius();
        this.cancelAnimations();
        this.rippleAnimator = new AnimatorSet();
        this.rippleAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!MaterialRippleLayout.this.ripplePersistent) {
                    MaterialRippleLayout.this.setRadius(0.0f);
                    MaterialRippleLayout.this.setRippleAlpha(MaterialRippleLayout.this.rippleAlpha);
                }
                if (animationEndRunnable != null && MaterialRippleLayout.this.rippleDelayClick) {
                    animationEndRunnable.run();
                }
                MaterialRippleLayout.this.childView.setPressed(false);
            }
        });
        ObjectAnimator ripple = ObjectAnimator.ofFloat((Object)((Object)this), this.radiusProperty, (float[])new float[]{this.radius, endRadius});
        ripple.setDuration((long)this.rippleDuration);
        ripple.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ObjectAnimator fade = ObjectAnimator.ofInt((Object)((Object)this), this.circleAlphaProperty, (int[])new int[]{this.rippleAlpha, 0});
        fade.setDuration((long)this.rippleFadeDuration);
        fade.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        fade.setStartDelay((long)(this.rippleDuration - this.rippleFadeDuration - 50));
        if (this.ripplePersistent) {
            this.rippleAnimator.play((Animator)ripple);
        } else if (this.getRadius() > endRadius) {
            fade.setStartDelay(0L);
            this.rippleAnimator.play((Animator)fade);
        } else {
            this.rippleAnimator.playTogether(new Animator[]{ripple, fade});
        }
        this.rippleAnimator.start();
    }

    private void cancelAnimations() {
        if (this.rippleAnimator != null) {
            this.rippleAnimator.cancel();
            this.rippleAnimator.removeAllListeners();
        }
        if (this.hoverAnimator != null) {
            this.hoverAnimator.cancel();
        }
    }

    private float getEndRadius() {
        int width = this.getWidth();
        int height = this.getHeight();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        float radiusX = halfWidth > this.currentCoords.x ? (float)(width - this.currentCoords.x) : (float)this.currentCoords.x;
        float radiusY = halfHeight > this.currentCoords.y ? (float)(height - this.currentCoords.y) : (float)this.currentCoords.y;
        return (float)Math.sqrt(Math.pow(radiusX, 2.0) + Math.pow(radiusY, 2.0)) * 1.2f;
    }

    private boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (!((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    private AdapterView findParentAdapterView() {
        if (this.parentAdapter != null) {
            return this.parentAdapter;
        }
        ViewParent current = this.getParent();
        while (true) {
            if (current instanceof AdapterView) {
                this.parentAdapter = (AdapterView)current;
                return this.parentAdapter;
            }
            try {
                current = current.getParent();
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("Could not find a parent AdapterView");
            }
        }
    }

    private void setPositionInAdapter() {
        if (this.rippleInAdapter) {
            this.positionInAdapter = this.findParentAdapterView().getPositionForView((View)this);
        }
    }

    private boolean adapterPositionChanged() {
        if (this.rippleInAdapter) {
            int newPosition = this.findParentAdapterView().getPositionForView((View)this);
            boolean changed = newPosition != this.positionInAdapter;
            this.positionInAdapter = newPosition;
            if (changed) {
                this.cancelPressedEvent();
                this.cancelAnimations();
                this.childView.setPressed(false);
                this.setRadius(0.0f);
            }
            return changed;
        }
        return false;
    }

    private boolean findClickableViewInChild(View view, int x, int y) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                Rect rect = new Rect();
                child.getHitRect(rect);
                boolean contains = rect.contains(x, y);
                if (!contains) continue;
                return this.findClickableViewInChild(child, x - rect.left, y - rect.top);
            }
        } else if (view != this.childView) {
            return view.isEnabled() && (view.isClickable() || view.isLongClickable() || view.isFocusableInTouchMode());
        }
        return view.isFocusableInTouchMode();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.bounds.set(0, 0, w, h);
        this.rippleBackground.setBounds(this.bounds);
    }

    public boolean isInEditMode() {
        return true;
    }

    public void draw(Canvas canvas) {
        boolean positionChanged = this.adapterPositionChanged();
        if (this.rippleOverlay) {
            if (!positionChanged) {
                this.rippleBackground.draw(canvas);
            }
            super.draw(canvas);
            if (!positionChanged) {
                if (this.rippleRoundedCorners != 0.0f) {
                    Path clipPath = new Path();
                    RectF rect = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
                    clipPath.addRoundRect(rect, this.rippleRoundedCorners, this.rippleRoundedCorners, Path.Direction.CW);
                    canvas.clipPath(clipPath);
                }
                canvas.drawCircle((float)this.currentCoords.x, (float)this.currentCoords.y, this.radius, this.paint);
            }
        } else {
            if (!positionChanged) {
                this.rippleBackground.draw(canvas);
                canvas.drawCircle((float)this.currentCoords.x, (float)this.currentCoords.y, this.radius, this.paint);
            }
            super.draw(canvas);
        }
    }

    private float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.invalidate();
    }

    public int getRippleAlpha() {
        return this.paint.getAlpha();
    }

    public void setRippleAlpha(Integer rippleAlpha) {
        this.paint.setAlpha(rippleAlpha.intValue());
        this.invalidate();
    }

    public void setRippleColor(int rippleColor) {
        this.rippleColor = rippleColor;
        this.paint.setColor(rippleColor);
        this.paint.setAlpha(this.rippleAlpha);
        this.invalidate();
    }

    public void setRippleOverlay(boolean rippleOverlay) {
        this.rippleOverlay = rippleOverlay;
    }

    public void setRippleDiameter(int rippleDiameter) {
        this.rippleDiameter = rippleDiameter;
    }

    public void setRippleDuration(int rippleDuration) {
        this.rippleDuration = rippleDuration;
    }

    public void setRippleBackground(int color) {
        this.rippleBackground = new ColorDrawable(color);
        this.rippleBackground.setBounds(this.bounds);
        this.invalidate();
    }

    public void setRippleHover(boolean rippleHover) {
        this.rippleHover = rippleHover;
    }

    public void setRippleDelayClick(boolean rippleDelayClick) {
        this.rippleDelayClick = rippleDelayClick;
    }

    public void setRippleFadeDuration(int rippleFadeDuration) {
        this.rippleFadeDuration = rippleFadeDuration;
    }

    public void setRipplePersistent(boolean ripplePersistent) {
        this.ripplePersistent = ripplePersistent;
    }

    public void setRippleInAdapter(boolean rippleInAdapter) {
        this.rippleInAdapter = rippleInAdapter;
    }

    public void setRippleRoundedCorners(int rippleRoundedCorner) {
        this.rippleRoundedCorners = rippleRoundedCorner;
        this.enableClipPathSupportIfNecessary();
    }

    public void setDefaultRippleAlpha(int alpha) {
        this.rippleAlpha = alpha;
        this.paint.setAlpha(alpha);
        this.invalidate();
    }

    public void performRipple() {
        this.currentCoords = new Point(this.getWidth() / 2, this.getHeight() / 2);
        this.startRipple(null);
    }

    public void performRipple(Point anchor) {
        this.currentCoords = new Point(anchor.x, anchor.y);
        this.startRipple(null);
    }

    private void enableClipPathSupportIfNecessary() {
        if (Build.VERSION.SDK_INT <= 17) {
            if (this.rippleRoundedCorners != 0.0f) {
                this.layerType = this.getLayerType();
                this.setLayerType(1, null);
            } else {
                this.setLayerType(this.layerType, null);
            }
        }
    }

    static float dpToPx(Resources resources, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static class RippleBuilder {
        private final Context context;
        private final View child;
        private int rippleColor = -16777216;
        private boolean rippleOverlay = false;
        private boolean rippleHover = true;
        private float rippleDiameter = 35.0f;
        private int rippleDuration = 350;
        private float rippleAlpha = 0.2f;
        private boolean rippleDelayClick = true;
        private int rippleFadeDuration = 75;
        private boolean ripplePersistent = false;
        private int rippleBackground = 0;
        private boolean rippleSearchAdapter = false;
        private float rippleRoundedCorner = 0.0f;

        public RippleBuilder(View child) {
            this.child = child;
            this.context = child.getContext();
        }

        public RippleBuilder rippleColor(int color) {
            this.rippleColor = color;
            return this;
        }

        public RippleBuilder rippleOverlay(boolean overlay) {
            this.rippleOverlay = overlay;
            return this;
        }

        public RippleBuilder rippleHover(boolean hover) {
            this.rippleHover = hover;
            return this;
        }

        public RippleBuilder rippleDiameterDp(int diameterDp) {
            this.rippleDiameter = diameterDp;
            return this;
        }

        public RippleBuilder rippleDuration(int duration) {
            this.rippleDuration = duration;
            return this;
        }

        public RippleBuilder rippleAlpha(float alpha) {
            this.rippleAlpha = 255.0f * alpha;
            return this;
        }

        public RippleBuilder rippleDelayClick(boolean delayClick) {
            this.rippleDelayClick = delayClick;
            return this;
        }

        public RippleBuilder rippleFadeDuration(int fadeDuration) {
            this.rippleFadeDuration = fadeDuration;
            return this;
        }

        public RippleBuilder ripplePersistent(boolean persistent) {
            this.ripplePersistent = persistent;
            return this;
        }

        public RippleBuilder rippleBackground(int color) {
            this.rippleBackground = color;
            return this;
        }

        public RippleBuilder rippleInAdapter(boolean inAdapter) {
            this.rippleSearchAdapter = inAdapter;
            return this;
        }

        public RippleBuilder rippleRoundedCorners(int radiusDp) {
            this.rippleRoundedCorner = radiusDp;
            return this;
        }

        public MaterialRippleLayout create() {
            MaterialRippleLayout layout = new MaterialRippleLayout(this.context);
            layout.setRippleColor(this.rippleColor);
            layout.setDefaultRippleAlpha((int)this.rippleAlpha);
            layout.setRippleDelayClick(this.rippleDelayClick);
            layout.setRippleDiameter((int)MaterialRippleLayout.dpToPx(this.context.getResources(), this.rippleDiameter));
            layout.setRippleDuration(this.rippleDuration);
            layout.setRippleFadeDuration(this.rippleFadeDuration);
            layout.setRippleHover(this.rippleHover);
            layout.setRipplePersistent(this.ripplePersistent);
            layout.setRippleOverlay(this.rippleOverlay);
            layout.setRippleBackground(this.rippleBackground);
            layout.setRippleInAdapter(this.rippleSearchAdapter);
            layout.setRippleRoundedCorners((int)MaterialRippleLayout.dpToPx(this.context.getResources(), this.rippleRoundedCorner));
            ViewGroup.LayoutParams params = this.child.getLayoutParams();
            ViewGroup parent = (ViewGroup)this.child.getParent();
            int index = 0;
            if (parent != null && parent instanceof MaterialRippleLayout) {
                throw new IllegalStateException("MaterialRippleLayout could not be created: parent of the view already is a MaterialRippleLayout");
            }
            if (parent != null) {
                index = parent.indexOfChild(this.child);
                parent.removeView(this.child);
            }
            layout.addView(this.child, new ViewGroup.LayoutParams(-1, -1));
            if (parent != null) {
                parent.addView((View)layout, index, params);
            }
            return layout;
        }
    }

    private final class PressedEvent
    implements Runnable {
        private final MotionEvent event;

        public PressedEvent(MotionEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            MaterialRippleLayout.this.prepressed = false;
            MaterialRippleLayout.this.childView.setLongClickable(false);
            MaterialRippleLayout.this.childView.onTouchEvent(this.event);
            MaterialRippleLayout.this.childView.setPressed(true);
            if (MaterialRippleLayout.this.rippleHover) {
                MaterialRippleLayout.this.startHover();
            }
        }
    }

    private class PerformClickEvent
    implements Runnable {
        private PerformClickEvent() {
        }

        @Override
        public void run() {
            if (MaterialRippleLayout.this.mHasPerformedLongPress) {
                return;
            }
            if (MaterialRippleLayout.this.getParent() instanceof AdapterView) {
                this.clickAdapterView((AdapterView)MaterialRippleLayout.this.getParent());
            } else if (MaterialRippleLayout.this.rippleInAdapter) {
                this.clickAdapterView(MaterialRippleLayout.this.findParentAdapterView());
            } else {
                MaterialRippleLayout.this.childView.performClick();
            }
        }

        private void clickAdapterView(AdapterView parent) {
            long itemId;
            int position = parent.getPositionForView((View)MaterialRippleLayout.this);
            long l = itemId = parent.getAdapter() != null ? parent.getAdapter().getItemId(position) : 0L;
            if (position != -1) {
                parent.performItemClick((View)MaterialRippleLayout.this, position, itemId);
            }
        }
    }
}

