/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vod.v2;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableFileInputStream;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.internal.RestartableResettableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.vod.v2.model.DeleteDomainRequest;
import com.baidubce.services.vod.v2.model.DisableDomainRequest;
import com.baidubce.services.vod.v2.model.DomainConfigRequest;
import com.baidubce.services.vod.v2.model.DomainCreateRequest;
import com.baidubce.services.vod.v2.model.DomainGetRequest;
import com.baidubce.services.vod.v2.model.DomainGetResponse;
import com.baidubce.services.vod.v2.model.DomainListRequest;
import com.baidubce.services.vod.v2.model.EnableDomainRequest;
import com.baidubce.services.vod.v2.model.FileUploadRequest;
import com.baidubce.services.vod.v2.model.ListByMarkerResponse;
import com.baidubce.services.vod.v2.model.ListByPageResponse;
import com.baidubce.services.vod.v2.model.MediaBanRequest;
import com.baidubce.services.vod.v2.model.MediaCompleteUploadResponse;
import com.baidubce.services.vod.v2.model.MediaComposeCreateRequest;
import com.baidubce.services.vod.v2.model.MediaComposeCreateResponse;
import com.baidubce.services.vod.v2.model.MediaDeleteRequest;
import com.baidubce.services.vod.v2.model.MediaGetRequest;
import com.baidubce.services.vod.v2.model.MediaGetResponse;
import com.baidubce.services.vod.v2.model.MediaListItem;
import com.baidubce.services.vod.v2.model.MediaListRequest;
import com.baidubce.services.vod.v2.model.MediaOutputDeleteRequest;
import com.baidubce.services.vod.v2.model.MediaProcessRequest;
import com.baidubce.services.vod.v2.model.MediaProcessResponse;
import com.baidubce.services.vod.v2.model.MediaTaskGetRequest;
import com.baidubce.services.vod.v2.model.MediaTaskGetResponse;
import com.baidubce.services.vod.v2.model.MediaTaskListItem;
import com.baidubce.services.vod.v2.model.MediaTaskListRequest;
import com.baidubce.services.vod.v2.model.MediaTaskRerunRequest;
import com.baidubce.services.vod.v2.model.MediaUnBanRequest;
import com.baidubce.services.vod.v2.model.MediaUpdateRequest;
import com.baidubce.services.vod.v2.model.MediaUploadDoneRequest;
import com.baidubce.services.vod.v2.model.MediaUploadRequest;
import com.baidubce.services.vod.v2.model.MediaUploadResponse;
import com.baidubce.services.vod.v2.model.PresetGetRequest;
import com.baidubce.services.vod.v2.model.PresetGetResponse;
import com.baidubce.services.vod.v2.model.PresetListRequest;
import com.baidubce.services.vod.v2.model.SecretKeyGetRequest;
import com.baidubce.services.vod.v2.model.SecretKeyGetResponse;
import com.baidubce.services.vod.v2.model.SecretKeyUpdateRequest;
import com.baidubce.services.vod.v2.model.SecretKeyUpdateResponse;
import com.baidubce.services.vod.v2.model.WorkflowGetRequest;
import com.baidubce.services.vod.v2.model.WorkflowGetResponse;
import com.baidubce.services.vod.v2.model.WorkflowListItem;
import com.baidubce.services.vod.v2.model.WorkflowListRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Mimetypes;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VodClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String MEDIAS = "medias";
    private static final String PROCESS = "process";
    private static final String TASKS = "tasks";
    private static final String WORKFLOWS = "workflows";
    private static final String DOMAINS = "domains";
    private static final String DOMAIN = "domain";
    private static final String UPDATE = "update";
    private static final String VALIDATE_DAG = "validateDag";
    private static final String VALIDATE_NAME = "validateName";
    private static final String COPY = "copy";
    private static final String OUTPUT = "output";
    private static final String DELETE = "delete";
    private static final String UPLOAD = "upload";
    private static final String COMPLETE_UOLOAD = "complete_upload";
    private static final String BAN = "ban";
    private static final String UNBAN = "unBan";
    private static final String MARKER = "marker";
    private static final String NAME = "name";
    private static final String MEDIA_ID = "mediaId";
    private static final String SOURCE_TYPE = "sourceType";
    private static final String BEGIN_TIME = "beginTime";
    private static final String END_TIME = "endTime";
    private static final String PAGE_NO = "pageNo";
    private static final String PAGE_SIZE = "pageSize";
    private static final String TYPE = "type";
    private static final String SORTBY = "sortBy";
    private static final String ENABLE_HTTPS = "enableHttps";
    private static final String BAN_STATUS = "banStatus";
    private static final String PUBLISH_STATUS = "publishStatus";
    private static final String TASK_ID = "taskId";
    private static final String STATUS = "status";
    private static final String RERUN = "rerun";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String CONFIG = "config";
    private static final String VALID = "valid";
    private static final String SECRET = "secret";
    private static final String PRESETS = "presets";
    private static final String NOTIFICATIONS = "notifications";
    private static final String MEDIACOMPOSE = "media_compose";
    private static final String PRESET_NAME = "vodPresetName";
    private static final String SERVICE_TYPE = "serviceType";
    private static final String HEADERSTREAM = "application/actet-stream";
    private static final HttpResponseHandler[] RESPONSE_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VodClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, RESPONSE_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillPayload(request, bceRequest);
        }
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            byte[] requestJson;
            String strJson = JsonUtils.toJsonString(bceRequest);
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public MediaGetResponse getMedia(MediaGetRequest mediaGetRequest) {
        InternalRequest request = this.createRequest(mediaGetRequest, HttpMethodName.GET, MEDIAS, mediaGetRequest.getMediaId());
        return this.invokeHttpClient(request, MediaGetResponse.class);
    }

    public ListByMarkerResponse<MediaListItem> listMedia(int maxSize) {
        MediaListRequest listRequest = new MediaListRequest();
        listRequest.setMaxSize(maxSize);
        return this.listMedia(maxSize, null);
    }

    public ListByMarkerResponse<MediaListItem> listMedia(int maxSize, String marker) {
        MediaListRequest listRequest = new MediaListRequest();
        listRequest.setMaxSize(maxSize);
        listRequest.setMarker(marker);
        return this.listMedia(maxSize, marker, null);
    }

    public ListByMarkerResponse<MediaListItem> listMedia(int maxSize, String marker, String banStatus) {
        MediaListRequest listRequest = new MediaListRequest();
        listRequest.setMaxSize(maxSize);
        listRequest.setBanStatus(banStatus);
        listRequest.setMarker(marker);
        return this.listMedia(listRequest);
    }

    public ListByMarkerResponse<MediaListItem> listMedia(MediaListRequest listRequest) {
        InternalRequest request = this.createRequest(listRequest, HttpMethodName.GET, MEDIAS);
        request.addParameter("maxSize", String.valueOf(listRequest.getMaxSize()));
        if (StringUtils.isNotBlank((String)listRequest.getMarker())) {
            request.addParameter(MARKER, listRequest.getMarker());
        }
        if (StringUtils.isNotBlank((String)listRequest.getName())) {
            request.addParameter(NAME, listRequest.getName());
        }
        if (StringUtils.isNotBlank((String)listRequest.getMediaId())) {
            request.addParameter(MEDIA_ID, listRequest.getMediaId());
        }
        if (StringUtils.isNotBlank((String)listRequest.getSourceType())) {
            request.addParameter(SOURCE_TYPE, listRequest.getSourceType());
        }
        if (StringUtils.isNotBlank((String)listRequest.getBeginTime())) {
            request.addParameter(BEGIN_TIME, listRequest.getBeginTime());
        }
        if (StringUtils.isNotBlank((String)listRequest.getEndTime())) {
            request.addParameter(END_TIME, listRequest.getEndTime());
        }
        if (StringUtils.isNotBlank((String)listRequest.getBanStatus())) {
            request.addParameter(BAN_STATUS, listRequest.getBanStatus());
        }
        return this.invokeHttpClient(request, ListByMarkerResponse.class);
    }

    public MediaProcessResponse processMedia(MediaProcessRequest mediaProcessRequest) {
        InternalRequest request = this.createRequest(mediaProcessRequest, HttpMethodName.POST, MEDIAS, PROCESS);
        return this.invokeHttpClient(request, MediaProcessResponse.class);
    }

    public void updateMedia(String mediaId, MediaUpdateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, MEDIAS, mediaId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteMediaOutput(String mediaId, MediaOutputDeleteRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, MEDIAS, mediaId, OUTPUT, DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteMedia(String mediaId) {
        MediaDeleteRequest request = new MediaDeleteRequest();
        ArrayList<String> mediaIds = new ArrayList<String>();
        mediaIds.add(mediaId);
        request.setMediaIds(mediaIds);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, MEDIAS, mediaId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchDeleteMedia(MediaDeleteRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, MEDIAS, DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void banMedia(String mediaId) {
        MediaBanRequest mediaBanRequest = new MediaBanRequest();
        mediaBanRequest.setMediaId(mediaId);
        this.banMedia(mediaBanRequest);
    }

    public void banMedia(MediaBanRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, MEDIAS, BAN);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unBanMedia(String mediaId) {
        MediaUnBanRequest mediaUnBanRequest = new MediaUnBanRequest();
        mediaUnBanRequest.setMediaId(mediaId);
        this.unBanMedia(mediaUnBanRequest);
    }

    public void unBanMedia(MediaUnBanRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, MEDIAS, UNBAN);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public MediaUploadResponse createUpload(String name, String container) {
        MediaUploadRequest mediaUploadRequest = new MediaUploadRequest();
        mediaUploadRequest.setName(name);
        mediaUploadRequest.setContainer(container);
        return this.createUpload(mediaUploadRequest);
    }

    public MediaUploadResponse createUpload(MediaUploadRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, MEDIAS, UPLOAD);
        return this.invokeHttpClient(internalRequest, MediaUploadResponse.class);
    }

    public MediaUploadResponse createMultipartUpload(String name, String container, int numParts) {
        MediaUploadRequest mediaUploadRequest = new MediaUploadRequest();
        mediaUploadRequest.setName(name);
        mediaUploadRequest.setContainer(container);
        mediaUploadRequest.setMultipartUpload(true);
        mediaUploadRequest.setNumParts(numParts);
        return this.createUpload(mediaUploadRequest);
    }

    public MediaCompleteUploadResponse completeUpload(MediaUploadDoneRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, MEDIAS, COMPLETE_UOLOAD);
        return this.invokeHttpClient(internalRequest, MediaCompleteUploadResponse.class);
    }

    public MediaCompleteUploadResponse createMedia(FileUploadRequest request, String name, String container) {
        MediaUploadResponse mediaUploadResponse = this.createUpload(name, container);
        URI uri = null;
        try {
            uri = new URI(mediaUploadResponse.getUrls().get(0));
        }
        catch (URISyntaxException e) {
            throw new BceClientException("Unable to find file to upload", e);
        }
        InternalRequest internalRequest = new InternalRequest(HttpMethodName.PUT, uri);
        if (request.getFile().length() > 0x140000000L) {
            BceServiceException bse = new BceServiceException("Your proposed upload exceeds the maximum allowed object size.");
            bse.setStatusCode(400);
            bse.setErrorCode("EntityTooLarge");
            bse.setErrorType(BceServiceException.ErrorType.Client);
            throw bse;
        }
        try {
            String mimetype = Mimetypes.getInstance().getMimetype(request.getFile());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", mimetype);
            internalRequest.setHeaders(headers);
            internalRequest.setContent(new RestartableFileInputStream(request.getFile()));
            this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        }
        catch (FileNotFoundException e) {
            throw new BceClientException("Unable to find file to upload", e);
        }
        MediaUploadDoneRequest mediaUploadDoneRequest = new MediaUploadDoneRequest();
        mediaUploadDoneRequest.setSessionKey(mediaUploadResponse.getSessionKey());
        return this.completeUpload(mediaUploadDoneRequest);
    }

    public MediaCompleteUploadResponse createMedia(FileUploadRequest request, String name, String container, int numParts) {
        ArrayList<String> etgs = new ArrayList<String>();
        MediaUploadRequest mediaUploadRequest = new MediaUploadRequest();
        mediaUploadRequest.setName(name);
        mediaUploadRequest.setContainer(container);
        mediaUploadRequest.setMultipartUpload(true);
        mediaUploadRequest.setNumParts(numParts);
        MediaUploadResponse mediaUploadResponse = this.createUpload(mediaUploadRequest);
        List<String> urls = mediaUploadResponse.getUrls();
        File sourceFile = request.getFile();
        long fileSize = sourceFile.length();
        long chunkSize = fileSize / (long)numParts;
        long remainingBytes = fileSize % (long)numParts;
        try (FileInputStream fis = new FileInputStream(sourceFile);){
            for (int i = 0; i < numParts; ++i) {
                long currentChunkSize = chunkSize + (long)((long)i < remainingBytes ? 1 : 0);
                byte[] buffer = new byte[(int)currentChunkSize];
                int bytesRead = fis.read(buffer);
                if (bytesRead == -1) {
                    break;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                URI uri = new URI(urls.get(i));
                InternalRequest internalRequest = new InternalRequest(HttpMethodName.PUT, uri);
                RestartableResettableInputStream inputStream = new RestartableResettableInputStream(bais);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", HEADERSTREAM);
                internalRequest.setHeaders(headers);
                internalRequest.setContent(inputStream);
                AbstractBceResponse abstractBceResponse = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
                etgs.add(abstractBceResponse.getMetadata().getETag());
            }
        }
        catch (IOException e) {
            throw new BceClientException("upload file failed", e);
        }
        catch (URISyntaxException e) {
            throw new BceClientException("upload file failed", e);
        }
        MediaUploadDoneRequest mediaUploadDoneRequest = new MediaUploadDoneRequest();
        mediaUploadDoneRequest.setSessionKey(mediaUploadResponse.getSessionKey());
        mediaUploadDoneRequest.setMultipartUpload(true);
        mediaUploadDoneRequest.setEtags(etgs);
        return this.completeUpload(mediaUploadDoneRequest);
    }

    public void uoloadLocalFile(FileUploadRequest request, String uploadUri) {
        URI uri = null;
        try {
            uri = new URI(uploadUri);
        }
        catch (URISyntaxException e) {
            throw new BceClientException("Unable to find file to upload", e);
        }
        InternalRequest internalRequest = new InternalRequest(HttpMethodName.PUT, uri);
        if (request.getFile().length() > 0x140000000L) {
            BceServiceException bse = new BceServiceException("Your proposed upload exceeds the maximum allowed object size.");
            bse.setStatusCode(400);
            bse.setErrorCode("EntityTooLarge");
            bse.setErrorType(BceServiceException.ErrorType.Client);
            throw bse;
        }
        try {
            String mimetype = Mimetypes.getInstance().getMimetype(request.getFile());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", mimetype);
            internalRequest.setHeaders(headers);
            internalRequest.setContent(new RestartableFileInputStream(request.getFile()));
            this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        }
        catch (FileNotFoundException e) {
            throw new BceClientException("Unable to find file to upload", e);
        }
    }

    public List<String> uoloadLocalFilePart(FileUploadRequest request, int numParts, List<String> urls) {
        ArrayList<String> etgs = new ArrayList<String>();
        File sourceFile = request.getFile();
        long fileSize = sourceFile.length();
        long chunkSize = fileSize / (long)numParts;
        long remainingBytes = fileSize % (long)numParts;
        try (FileInputStream fis = new FileInputStream(sourceFile);){
            for (int i = 0; i < numParts; ++i) {
                long currentChunkSize = chunkSize + (long)((long)i < remainingBytes ? 1 : 0);
                byte[] buffer = new byte[(int)currentChunkSize];
                int bytesRead = fis.read(buffer);
                if (bytesRead == -1) {
                    break;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                URI uri = new URI(urls.get(i));
                InternalRequest internalRequest = new InternalRequest(HttpMethodName.PUT, uri);
                RestartableResettableInputStream inputStream = new RestartableResettableInputStream(bais);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", HEADERSTREAM);
                internalRequest.setHeaders(headers);
                internalRequest.setContent(inputStream);
                AbstractBceResponse abstractBceResponse = this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
                etgs.add(abstractBceResponse.getMetadata().getETag());
            }
        }
        catch (IOException e) {
            throw new BceClientException("upload file failed", e);
        }
        catch (URISyntaxException e) {
            throw new BceClientException("upload file failed", e);
        }
        return etgs;
    }

    public ListByMarkerResponse<MediaTaskListItem> listMediaTaskByMarker(int maxSize) {
        return this.listMediaTaskByMarker(maxSize, null);
    }

    public ListByMarkerResponse<MediaTaskListItem> listMediaTaskByMarker(int maxSize, String marker) {
        MediaTaskListRequest mediaTaskListRequest = new MediaTaskListRequest();
        mediaTaskListRequest.setMaxSize(maxSize);
        mediaTaskListRequest.setMarker(marker);
        return this.listMediaTaskByMarker(mediaTaskListRequest);
    }

    public ListByMarkerResponse<MediaTaskListItem> listMediaTaskByMarker(MediaTaskListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, TASKS);
        internalRequest.addParameter("maxSize", String.valueOf(request.getMaxSize()));
        if (StringUtils.isNotBlank((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (StringUtils.isNotBlank((String)request.getMediaId())) {
            internalRequest.addParameter(MEDIA_ID, request.getMediaId());
        }
        if (StringUtils.isNotBlank((String)request.getTaskId())) {
            internalRequest.addParameter(TASK_ID, request.getTaskId());
        }
        if (StringUtils.isNotBlank((String)request.getStatus())) {
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        if (StringUtils.isNotBlank((String)request.getBeginTime())) {
            internalRequest.addParameter(BEGIN_TIME, request.getBeginTime());
        }
        if (StringUtils.isNotBlank((String)request.getEndTime())) {
            internalRequest.addParameter(END_TIME, request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, ListByMarkerResponse.class);
    }

    public MediaTaskGetResponse getMediaTask(String taskId) {
        MediaTaskGetRequest mediaTaskGetRequest = new MediaTaskGetRequest();
        mediaTaskGetRequest.setTaskId(taskId);
        InternalRequest internalRequest = this.createRequest(mediaTaskGetRequest, HttpMethodName.GET, TASKS, taskId);
        return this.invokeHttpClient(internalRequest, MediaTaskGetResponse.class);
    }

    public void rerunTask(String taskId) {
        MediaTaskRerunRequest mediaTaskRerunRequest = new MediaTaskRerunRequest();
        mediaTaskRerunRequest.setTaskId(taskId);
        InternalRequest internalRequest = this.createRequest(mediaTaskRerunRequest, HttpMethodName.POST, TASKS, RERUN);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public WorkflowGetResponse getWorkflow(String workflowId) {
        WorkflowGetRequest request = new WorkflowGetRequest();
        request.setWorkflowId(workflowId);
        return this.getWorkflow(request);
    }

    public WorkflowGetResponse getWorkflow(WorkflowGetRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKFLOWS, request.getWorkflowId());
        return this.invokeHttpClient(internalRequest, WorkflowGetResponse.class);
    }

    public ListByPageResponse<WorkflowListItem> listWorkflow(int pageNo, int pageSize) {
        return this.listWorkflow(pageNo, pageSize, null, null);
    }

    public ListByPageResponse<WorkflowListItem> listWorkflow(int pageNo, int pageSize, String beginTime, String endTime) {
        WorkflowListRequest request = new WorkflowListRequest();
        request.setPageNo(pageNo);
        request.setPageSize(pageSize);
        request.setBeginTime(beginTime);
        request.setEndTime(endTime);
        return this.listWorkflow(request);
    }

    public ListByPageResponse<WorkflowListItem> listWorkflow(WorkflowListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKFLOWS);
        internalRequest.addParameter(PAGE_NO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PAGE_SIZE, String.valueOf(request.getPageSize()));
        if (StringUtils.isNotBlank((String)request.getName())) {
            internalRequest.addParameter(NAME, request.getName());
        }
        if (StringUtils.isNotBlank((String)request.getBeginTime())) {
            internalRequest.addParameter(BEGIN_TIME, request.getBeginTime());
        }
        if (StringUtils.isNotBlank((String)request.getEndTime())) {
            internalRequest.addParameter(END_TIME, request.getEndTime());
        }
        if (StringUtils.isNotBlank((String)request.getType())) {
            internalRequest.addParameter(TYPE, request.getType());
        }
        if (StringUtils.isNotBlank((String)request.getSortBy())) {
            internalRequest.addParameter(SORTBY, request.getSortBy());
        }
        return this.invokeHttpClient(internalRequest, ListByPageResponse.class);
    }

    public DomainGetResponse getDomain(String domain) {
        DomainGetRequest request = new DomainGetRequest();
        request.setDomain(domain);
        return this.getDomain(request);
    }

    public DomainGetResponse getDomain(DomainGetRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAINS, request.getDomain());
        return this.invokeHttpClient(internalRequest, DomainGetResponse.class);
    }

    public ListByPageResponse<DomainGetResponse> listDomainByPage(int pageNo, int pageSize) {
        DomainListRequest request = new DomainListRequest();
        request.setPageNo(pageNo);
        request.setPageSize(pageSize);
        return this.listDomainByPage(request);
    }

    public ListByPageResponse<DomainGetResponse> listDomainByPage(DomainListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAINS);
        internalRequest.addParameter(PAGE_NO, Integer.toString(request.getPageNo()));
        internalRequest.addParameter(PAGE_SIZE, Integer.toString(request.getPageSize()));
        if (StringUtils.isNotBlank((String)request.getStatus())) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (StringUtils.isNotBlank((String)request.getType())) {
            internalRequest.addParameter(TYPE, request.getType());
        }
        if (null != request.getEnableHttps()) {
            internalRequest.addParameter(ENABLE_HTTPS, String.valueOf(request.getEnableHttps()));
        }
        if (StringUtils.isNotBlank((String)request.getStatus())) {
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        if (StringUtils.isNotBlank((String)request.getSortBy())) {
            internalRequest.addParameter(SORTBY, request.getSortBy());
        }
        return this.invokeHttpClient(internalRequest, ListByPageResponse.class);
    }

    public DomainGetResponse createDomain(String domain) {
        DomainCreateRequest request = new DomainCreateRequest();
        request.setDomain(domain);
        return this.createDomain(request);
    }

    public DomainGetResponse createDomain(DomainCreateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAINS);
        return this.invokeHttpClient(internalRequest, DomainGetResponse.class);
    }

    public void domainConfig(String domain) {
        DomainConfigRequest request = new DomainConfigRequest();
        request.setDomain(domain);
        this.domainConfig(request);
    }

    public void domainConfig(DomainConfigRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAINS, request.getDomain(), CONFIG);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void enableDomain(String domain) {
        EnableDomainRequest request = new EnableDomainRequest();
        request.setDomain(domain);
        this.enableDomain(request);
    }

    public void enableDomain(EnableDomainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAINS, request.getDomain(), ENABLE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void disAbleDomain(String domain) {
        DisableDomainRequest request = new DisableDomainRequest();
        request.setDomain(domain);
        this.disAbleDomain(request);
    }

    public void disAbleDomain(DisableDomainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAINS, request.getDomain(), DISABLE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteDomain(String domain) {
        DeleteDomainRequest request = new DeleteDomainRequest();
        request.setDomain(domain);
        this.deleteDomain(request);
    }

    public void deleteDomain(DeleteDomainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, DOMAINS, request.getDomain());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public SecretKeyGetResponse getSecretKey() {
        SecretKeyGetRequest request = new SecretKeyGetRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SECRET);
        internalRequest.addParameter("appId", "");
        return this.invokeHttpClient(internalRequest, SecretKeyGetResponse.class);
    }

    public SecretKeyUpdateResponse updateSecretKey() {
        SecretKeyUpdateRequest request = new SecretKeyUpdateRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SECRET);
        internalRequest.addParameter("appId", "");
        return this.invokeHttpClient(internalRequest, SecretKeyUpdateResponse.class);
    }

    public PresetGetResponse getPreset(String presetName) {
        PresetGetRequest request = new PresetGetRequest();
        request.setPresetName(presetName);
        return this.getPreset(request);
    }

    public PresetGetResponse getPreset(PresetGetRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PRESETS, request.getPresetName());
        return this.invokeHttpClient(internalRequest, PresetGetResponse.class);
    }

    public ListByPageResponse<PresetGetResponse> listPreset(int pageNo, int pageSize) {
        return this.listPreset(pageNo, pageSize, null);
    }

    public ListByPageResponse<PresetGetResponse> listPreset(int pageNo, int pageSize, String type) {
        PresetListRequest request = new PresetListRequest();
        request.setPageNo(pageNo);
        request.setPageSize(pageSize);
        request.setType(type);
        return this.listPreset(request);
    }

    public ListByPageResponse<PresetGetResponse> listPreset(PresetListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PRESETS);
        internalRequest.addParameter(PAGE_NO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PAGE_SIZE, String.valueOf(request.getPageSize()));
        if (StringUtils.isNotBlank((String)request.getVodPresetName())) {
            internalRequest.addParameter(PRESET_NAME, request.getVodPresetName());
        }
        if (StringUtils.isNotBlank((String)request.getServiceType())) {
            internalRequest.addParameter(SERVICE_TYPE, request.getServiceType());
        }
        if (StringUtils.isNotBlank((String)request.getType())) {
            internalRequest.addParameter(TYPE, request.getType());
        }
        if (StringUtils.isNotBlank((String)request.getSortBy())) {
            internalRequest.addParameter(SORTBY, request.getSortBy());
        }
        return this.invokeHttpClient(internalRequest, ListByPageResponse.class);
    }

    public MediaComposeCreateResponse createMediaCompose(MediaComposeCreateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, MEDIACOMPOSE);
        return this.invokeHttpClient(internalRequest, MediaComposeCreateResponse.class);
    }
}

