/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.eipgroup;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.eipgroup.EipGroupClientConfiguration;
import com.baidubce.services.eipgroup.model.BandwidthInMbpsRequest;
import com.baidubce.services.eipgroup.model.CreateEipGroupRequest;
import com.baidubce.services.eipgroup.model.EipCountRequest;
import com.baidubce.services.eipgroup.model.EipGroupOperateRequest;
import com.baidubce.services.eipgroup.model.EipNameRequest;
import com.baidubce.services.eipgroup.model.GetEipGroupRequest;
import com.baidubce.services.eipgroup.model.GetEipGroupResponse;
import com.baidubce.services.eipgroup.model.IdResponse;
import com.baidubce.services.eipgroup.model.ListEipGroupRequest;
import com.baidubce.services.eipgroup.model.ListEipGroupResponse;
import com.baidubce.services.eipgroup.model.MoveInRequest;
import com.baidubce.services.eipgroup.model.MoveOutRequest;
import com.baidubce.services.eipgroup.model.PurchaseReservedEipGroupRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EipGroupClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EipGroupClient.class);
    private static final String VERSION = "v1";
    private static final String PREFIX = "eipgroup";
    private static final HttpResponseHandler[] HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EipGroupClient() {
        this(new EipGroupClientConfiguration());
    }

    public EipGroupClient(EipGroupClientConfiguration clientConfiguration) {
        super(clientConfiguration, HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public IdResponse createEipGroup(CreateEipGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)request.getBilling(), (Object)"billing should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, IdResponse.class);
    }

    public void resizeBandwidth(BandwidthInMbpsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getId());
        internalRequest.addParameter("resize", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void update(EipNameRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getId());
        internalRequest.addParameter("update", null);
        this.fillPayload(internalRequest, request);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void addCount(EipCountRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getId());
        internalRequest.addParameter("resize", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListEipGroupResponse listEipGroup(ListEipGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PREFIX);
        if (StringUtils.isNotBlank((CharSequence)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (StringUtils.isNotBlank((CharSequence)request.getId())) {
            internalRequest.addParameter("id", request.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getStatus())) {
            internalRequest.addParameter("status", request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListEipGroupResponse.class);
    }

    public GetEipGroupResponse getEipGroup(GetEipGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getId(), "id should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PREFIX, request.getId());
        return this.invokeHttpClient(internalRequest, GetEipGroupResponse.class);
    }

    public void purchaseReservedEipGroup(PurchaseReservedEipGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getId(), "id should not be empty.");
        Preconditions.checkNotNull((Object)request.getBilling(), (Object)"billing should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getId());
        internalRequest.addParameter("purchaseReserved", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseEipGroup(EipGroupOperateRequest request) {
        Validate.checkStringNotEmpty(request.getId(), "id should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, PREFIX, request.getId());
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void moveOutEips(MoveOutRequest request) {
        Validate.checkStringNotEmpty(request.getId(), "id should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getId());
        internalRequest.addParameter("move_out", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void moveInEips(MoveInRequest request) {
        Validate.checkStringNotEmpty(request.getId(), "id should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PREFIX, request.getId());
        internalRequest.addParameter("move_in", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

