/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.services.bos.model.BosProgressCallback;
import com.baidubce.services.bos.model.GenericObjectRequest;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;

public class PutObjectRequest
extends GenericObjectRequest {
    private File file;
    private InputStream inputStream;
    private ObjectMetadata objectMetadata = new ObjectMetadata();
    private String storageClass;
    private String videoProcess = null;
    private BosProgressCallback progressCallback = null;
    private String xBceAcl = null;
    private String xBceProcess = null;
    private boolean xBceCrc32cFlag = false;

    public PutObjectRequest(String bucketName, String key, File file) {
        this(bucketName, key, file, null, new ObjectMetadata());
        Preconditions.checkNotNull((Object)file, (Object)"file should not be null.");
    }

    public PutObjectRequest(String bucketName, String key, File file, ObjectMetadata metadata) {
        this(bucketName, key, file, null, metadata);
        Preconditions.checkNotNull((Object)file, (Object)"file should not be null.");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata should not be null.");
    }

    public PutObjectRequest(String bucketName, String key, InputStream inputStream) {
        this(bucketName, key, null, inputStream, new ObjectMetadata());
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream should not be null.");
    }

    public PutObjectRequest(String bucketName, String key, InputStream inputStream, BosProgressCallback progressCallback) {
        this(bucketName, key, null, inputStream, new ObjectMetadata());
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream should not be null.");
        this.setProgressCallback(progressCallback);
    }

    public PutObjectRequest(String bucketName, String key, InputStream inputStream, ObjectMetadata metadata) {
        this(bucketName, key, null, inputStream, metadata);
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream should not be null.");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata should not be null.");
    }

    protected PutObjectRequest(String bucketName, String key, File file, InputStream inputStream, ObjectMetadata objectMetadata) {
        super(bucketName, key);
        this.file = file;
        this.inputStream = inputStream;
        this.objectMetadata = objectMetadata;
    }

    @Override
    public PutObjectRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    @Override
    public PutObjectRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    @Override
    public PutObjectRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public PutObjectRequest withFile(File file) {
        this.setFile(file);
        return this;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public PutObjectRequest withObjectMetadata(ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public PutObjectRequest withInputStream(InputStream inputStream) {
        this.setInputStream(inputStream);
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public PutObjectRequest withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public BosProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    public void setProgressCallback(BosProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public PutObjectRequest withProgressCallback(BosProgressCallback progressCallback) {
        this.setProgressCallback(progressCallback);
        return this;
    }

    public long getTrafficLimitBitPS() {
        return this.trafficLimitBitPS;
    }

    public void setTrafficLimitBitPS(long trafficLimitBitPS) {
        this.trafficLimitBitPS = trafficLimitBitPS;
    }

    public PutObjectRequest withTrafficLimitBitPS(long trafficLimitBitPS) {
        this.setTrafficLimitBitPS(trafficLimitBitPS);
        return this;
    }

    public String getVideoProcess() {
        return this.videoProcess;
    }

    public void setVideoProcess(String videoProcess) {
        this.videoProcess = videoProcess;
    }

    public PutObjectRequest withVideoProcess(String videoProcess) {
        this.setVideoProcess(videoProcess);
        return this;
    }

    public boolean getxBceCrc32cFlag() {
        return this.xBceCrc32cFlag;
    }

    public void setxBceCrc32cFlag(boolean xBceCrc32cFlag) {
        this.xBceCrc32cFlag = xBceCrc32cFlag;
    }

    public String getxBceAcl() {
        return this.xBceAcl;
    }

    public void setxBceAcl(String acl) {
        this.xBceAcl = acl;
    }

    public String getxBceProcess() {
        return this.xBceProcess;
    }

    public void setxBceProcess(String xBceProcess) {
        this.xBceProcess = xBceProcess;
    }
}

