/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.com.squareup.protoparser;

import com.baidu.jprotobuf.com.squareup.protoparser.AutoValue_RpcElement;
import com.baidu.jprotobuf.com.squareup.protoparser.DataType;
import com.baidu.jprotobuf.com.squareup.protoparser.OptionElement;
import com.baidu.jprotobuf.com.squareup.protoparser.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class RpcElement {
    public static Builder builder() {
        return new Builder();
    }

    RpcElement() {
    }

    public abstract String name();

    public abstract String documentation();

    public abstract DataType.NamedType requestType();

    public abstract DataType.NamedType responseType();

    public abstract List<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        builder.append("rpc ").append(this.name()).append(" (").append(this.requestType()).append(") returns (").append(this.responseType()).append(')');
        if (!this.options().isEmpty()) {
            builder.append(" {\n");
            for (OptionElement option : this.options()) {
                Utils.appendIndented(builder, option.toSchemaDeclaration());
            }
            builder.append("}");
        }
        return builder.append(";\n").toString();
    }

    public static final class Builder {
        private String name;
        private String documentation = "";
        private DataType.NamedType requestType;
        private DataType.NamedType responseType;
        private final List<OptionElement> options = new ArrayList<OptionElement>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Utils.checkNotNull(name, "name");
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = Utils.checkNotNull(documentation, "documentation");
            return this;
        }

        public Builder requestType(DataType.NamedType requestType) {
            this.requestType = Utils.checkNotNull(requestType, "requestType");
            return this;
        }

        public Builder responseType(DataType.NamedType responseType) {
            this.responseType = Utils.checkNotNull(responseType, "responseType");
            return this;
        }

        public Builder addOption(OptionElement option) {
            this.options.add(Utils.checkNotNull(option, "option"));
            return this;
        }

        public Builder addOptions(Collection<OptionElement> options) {
            for (OptionElement option : Utils.checkNotNull(options, "options")) {
                this.addOption(option);
            }
            return this;
        }

        public RpcElement build() {
            Utils.checkNotNull(this.name, "name");
            Utils.checkNotNull(this.requestType, "requestType");
            Utils.checkNotNull(this.responseType, "responseType");
            return new AutoValue_RpcElement(this.name, this.documentation, this.requestType, this.responseType, Utils.immutableCopyOf(this.options));
        }
    }
}

