/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.com.squareup.protoparser;

import com.baidu.jprotobuf.com.squareup.protoparser.AutoValue_OptionElement;
import com.baidu.jprotobuf.com.squareup.protoparser.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OptionElement {
    public static Map<String, Object> optionsAsMap(List<OptionElement> options) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (OptionElement option : options) {
            String name = option.name();
            Object value = option.value();
            if (value instanceof String || value instanceof List) {
                map.put(name, value);
                continue;
            }
            if (value instanceof OptionElement) {
                Map<String, Object> newMap = OptionElement.optionsAsMap(Collections.singletonList((OptionElement)value));
                Object oldValue = map.get(name);
                if (oldValue instanceof Map) {
                    LinkedHashMap<String, Object> oldMap = (LinkedHashMap<String, Object>)oldValue;
                    oldMap = new LinkedHashMap<String, Object>(oldMap);
                    oldMap.putAll(newMap);
                    map.put(name, oldMap);
                    continue;
                }
                map.put(name, newMap);
                continue;
            }
            if (value instanceof Map) {
                Object oldValue = map.get(name);
                if (oldValue instanceof Map) {
                    ((Map)oldValue).putAll((Map)value);
                    continue;
                }
                map.put(name, value);
                continue;
            }
            throw new AssertionError((Object)"Option value must be String, Option, List, or Map<String, ?>");
        }
        return Collections.unmodifiableMap(map);
    }

    public static OptionElement findByName(List<OptionElement> options, String name) {
        Utils.checkNotNull(options, "options");
        Utils.checkNotNull(name, "name");
        OptionElement found = null;
        for (OptionElement option : options) {
            if (!option.name().equals(name)) continue;
            if (found != null) {
                throw new IllegalStateException("Multiple options match name: " + name);
            }
            found = option;
        }
        return found;
    }

    public static OptionElement create(String name, Kind kind, Object value) {
        return OptionElement.create(name, kind, value, false);
    }

    public static OptionElement create(String name, Kind kind, Object value, boolean isParenthesized) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(value, "value");
        return new AutoValue_OptionElement(name, kind, value, isParenthesized);
    }

    OptionElement() {
    }

    public abstract String name();

    public abstract Kind kind();

    public abstract Object value();

    public abstract boolean isParenthesized();

    public final String toSchema() {
        Object value = this.value();
        switch (this.kind()) {
            case STRING: {
                return this.formatName() + " = \"" + value + '\"';
            }
            case BOOLEAN: 
            case NUMBER: 
            case ENUM: {
                return this.formatName() + " = " + value;
            }
            case OPTION: {
                StringBuilder builder = new StringBuilder();
                OptionElement optionValue = (OptionElement)value;
                optionValue = OptionElement.create(optionValue.name(), optionValue.kind(), optionValue.value());
                builder.append(this.formatName()).append('.').append(optionValue.toSchema());
                return builder.toString();
            }
            case MAP: {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formatName()).append(" = {\n");
                Map valueMap = (Map)value;
                OptionElement.formatOptionMap(builder, valueMap);
                builder.append('}');
                return builder.toString();
            }
            case LIST: {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formatName()).append(" = [\n");
                List optionList = (List)value;
                OptionElement.formatOptionList(builder, optionList);
                builder.append(']');
                return builder.toString();
            }
        }
        throw new AssertionError();
    }

    public final String toSchemaDeclaration() {
        return "option " + this.toSchema() + ";\n";
    }

    static void formatOptionList(StringBuilder builder, List<OptionElement> optionList) {
        int count = optionList.size();
        for (int i = 0; i < count; ++i) {
            String endl = i < count - 1 ? "," : "";
            Utils.appendIndented(builder, optionList.get(i).toSchema() + endl);
        }
    }

    static void formatOptionMap(StringBuilder builder, Map<String, ?> valueMap) {
        ArrayList entries = new ArrayList(valueMap.entrySet());
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            String endl = i < count - 1 ? "," : "";
            Utils.appendIndented(builder, (String)entry.getKey() + ": " + OptionElement.formatOptionMapValue(entry.getValue()) + endl);
        }
    }

    static String formatOptionMapValue(Object value) {
        Utils.checkNotNull(value, "value == null");
        if (value instanceof String) {
            return "\"" + value + '\"';
        }
        if (value instanceof Map) {
            StringBuilder builder = new StringBuilder().append("{\n");
            Map map = (Map)value;
            OptionElement.formatOptionMap(builder, map);
            return builder.append('}').toString();
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder().append("[\n");
            List list = (List)value;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                String endl = i < count - 1 ? "," : "";
                Utils.appendIndented(builder, OptionElement.formatOptionMapValue(list.get(i)) + endl);
            }
            return builder.append("]").toString();
        }
        return value.toString();
    }

    private String formatName() {
        if (this.isParenthesized()) {
            return '(' + this.name() + ')';
        }
        return this.name();
    }

    public static enum Kind {
        STRING,
        BOOLEAN,
        NUMBER,
        ENUM,
        MAP,
        LIST,
        OPTION;

    }
}

