/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.nlp;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.nlp.ESimnetType;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class AipNlp
extends BaseClient {
    public AipNlp(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject lexer(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/lexer");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject lexerCustom(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/lexer_custom");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject depParser(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/depparser");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject wordEmbedding(String word, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("word", word);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/word_emb_vec");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject dnnlmCn(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/dnnlm_cn");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject wordSimEmbedding(String word1, String word2, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("word_1", word1);
        request.addBody("word_2", word2);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/word_emb_sim");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject simnet(String text1, String text2, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text_1", text1);
        request.addBody("text_2", text2);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/simnet");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject commentTag(String text, ESimnetType type, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        request.addBody("type", type.ordinal());
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/comment_tag");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sentimentClassify(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/sentiment_classify");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject keyword(String title, String content, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("title", title);
        request.addBody("content", content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/keyword");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject topic(String title, String content, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("title", title);
        request.addBody("content", content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/topic");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject ecnet(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/ecnet");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject textCorrection(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/text_correction");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject emotion(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/emotion");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject newsSummary(String content, int maxSummaryLen, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("content", content);
        request.addBody("max_summary_len", maxSummaryLen);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/news_summary");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject address(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/address");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject commentTagCustom(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/comment_tag_custom");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sentimentClassifyCustom(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/sentiment_classify_custom");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject couplets(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/creation/v1/couplets");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject poem(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/creation/v1/poem");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject entityLevelSentiment(String title, String content, Integer type, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("title", title);
        request.addBody("content", content);
        request.addBody("type", type);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/entity_level_sentiment");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject entityLevelSentimentAdd(String repository, List<String> entities, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("repository", repository);
        request.addBody("entities", entities);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/entity_level_sentiment/add");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject entityLevelSentimentDelete(String repository, List<String> entities, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("repository", repository);
        request.addBody("entities", entities);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/entity_level_sentiment/delete");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject entityLevelSentimentDeleteRepo(String repositories, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("repositories", repositories);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/entity_level_sentiment/delete_repo");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject entityLevelSentimentList() {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/entity_level_sentiment/list");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject entityLevelSentimentQuery(String repository, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("repository", repository);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/entity_level_sentiment/query");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject topicPhrase(String title, String summary, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("title", title);
        request.addBody("summary", summary);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/creation/v1/topic_phrase");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject recruitmentCvparser(String filename, String filetype, String filedata, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        JSONObject resume = new JSONObject();
        resume.put("filename", (Object)filename);
        resume.put("filetype", (Object)filetype);
        resume.put("filedata", (Object)filedata);
        if (options != null && options.containsKey("fields")) {
            resume.put("fields", options.get("fields"));
        }
        request.addBody("resume", resume);
        request.setUri("https://aip.baidubce.com/rpc/2.0/recruitment/v1/cvparser");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject recruitmentPersonPost(String filename, String filetype, String filedata, String title, String workContent, String serviceCondition, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        JSONObject resume = new JSONObject();
        resume.put("filename", (Object)filename);
        resume.put("filetype", (Object)filetype);
        resume.put("filedata", (Object)filedata);
        if (options != null && options.containsKey("fields")) {
            resume.put("fields", options.get("fields"));
        }
        request.addBody("resume", resume);
        JSONObject jobDescription = new JSONObject();
        jobDescription.put("title", (Object)title);
        jobDescription.put("work_content", (Object)workContent);
        jobDescription.put("service_condition", (Object)serviceCondition);
        request.addBody("job_description", jobDescription);
        request.setUri("https://aip.baidubce.com/rpc/2.0/recruitment/v1/person_post");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject recruitmentPersonas(String filename, String filetype, String filedata, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        JSONObject resume = new JSONObject();
        resume.put("filename", (Object)filename);
        resume.put("filetype", (Object)filetype);
        resume.put("filedata", (Object)filedata);
        request.addBody("resume", resume);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/recruitment/v1/personas");
        request.addHeader("Content-Encoding", "UTF8");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject titlepredictor(String doc, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("doc", doc);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/titlepredictor");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject depparserV2(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/depparser");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject blessCreation(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/bless_creation");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject entityAnalysis(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/entity_analysis");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }
}

