/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\n\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000b\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/badoo/reaktive/utils/EnhancedDelayQueue;", "T", "", "<init>", "()V", "queue", "Ljava/util/concurrent/DelayQueue;", "Lcom/badoo/reaktive/utils/EnhancedDelayQueue$Entry;", "set", "", "removeFirst", "()Ljava/lang/Object;", "offer", "", "item", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)V", "take", "Entry", "reaktive_debug"})
@SourceDebugExtension(value={"SMAP\nEnhancedDelayQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnhancedDelayQueue.kt\ncom/badoo/reaktive/utils/EnhancedDelayQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class EnhancedDelayQueue<T> {
    @NotNull
    private final DelayQueue<Entry<T>> queue = new DelayQueue();
    @NotNull
    private final Set<Entry<T>> set;

    public EnhancedDelayQueue() {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.set = set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final T removeFirst() {
        T t;
        Entry entry = (Entry)this.queue.peek();
        if (entry != null) {
            Entry entry2;
            Entry entry3 = entry;
            Object object = this.set;
            Entry p0 = entry3;
            boolean bl = false;
            Entry entry4 = entry2 = object.remove(p0) ? entry3 : null;
            if (entry2 != null) {
                Object it = object = entry2;
                boolean bl2 = false;
                this.queue.remove(it);
                t = ((Entry)object).getItem();
                return t;
            }
        }
        t = null;
        return t;
    }

    public final void offer(@NotNull T item, long timeout2, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Entry<T> entry = new Entry<T>(item, System.nanoTime() + timeUnit.toNanos(timeout2));
        ((Collection)this.set).add(entry);
        this.queue.offer((Entry<T>)((Delayed)entry));
    }

    @NotNull
    public final T take() {
        Object object;
        Entry p0;
        Set<Entry<T>> set;
        Entry entry;
        do {
            object = this.queue.take();
            set = this.set;
            p0 = (Entry)object;
            boolean bl = false;
        } while ((entry = (Entry)(set.remove(p0) ? object : null)) == null || (object = entry.getItem()) == null);
        Object it = object;
        boolean bl = false;
        return (T)it;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u0014*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0096\u0002R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/badoo/reaktive/utils/EnhancedDelayQueue$Entry;", "T", "Ljava/util/concurrent/Delayed;", "item", "expirationNanoTime", "", "<init>", "(Ljava/lang/Object;J)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getExpirationNanoTime", "()J", "sequenceNumber", "getDelay", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "compareTo", "", "other", "Companion", "reaktive_debug"})
    private static final class Entry<T>
    implements Delayed {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private final T item;
        private final long expirationNanoTime;
        private final long sequenceNumber;
        @NotNull
        private static final AtomicLong sequencer = new AtomicLong();

        public Entry(T item, long expirationNanoTime) {
            this.item = item;
            this.expirationNanoTime = expirationNanoTime;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        public final T getItem() {
            return this.item;
        }

        public final long getExpirationNanoTime() {
            return this.expirationNanoTime;
        }

        @Override
        public long getDelay(@NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            return timeUnit.convert(this.expirationNanoTime - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this == other) {
                n = 0;
            } else if (other instanceof Entry) {
                long timeDiff = this.expirationNanoTime - ((Entry)other).expirationNanoTime;
                n = timeDiff < 0L ? -1 : (timeDiff > 0L ? 1 : (this.sequenceNumber < ((Entry)other).sequenceNumber ? -1 : (this.sequenceNumber > ((Entry)other).sequenceNumber ? 1 : 0)));
            } else {
                long delayDiff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
                n = delayDiff < 0L ? -1 : (delayDiff > 0L ? 1 : 0);
            }
            return n;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/badoo/reaktive/utils/EnhancedDelayQueue$Entry$Companion;", "", "<init>", "()V", "sequencer", "Ljava/util/concurrent/atomic/AtomicLong;", "reaktive_debug"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

