/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.implementation.config;

import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpoint;
import com.azure.spring.messaging.implementation.listener.adapter.MessagingMessageListenerAdapter;
import com.azure.spring.messaging.listener.MessageListenerContainer;
import org.springframework.lang.Nullable;

public abstract class AbstractAzureListenerEndpoint
implements AzureListenerEndpoint {
    protected String id = "";
    @Nullable
    protected String destination;
    @Nullable
    protected String group;
    @Nullable
    protected String concurrency;

    @Override
    public void setupListenerContainer(MessageListenerContainer listenerContainer, AzureMessageConverter<?, ?> converter) {
        this.setupMessageListener(listenerContainer, converter);
    }

    protected abstract MessagingMessageListenerAdapter createMessageListener(MessageListenerContainer var1, @Nullable AzureMessageConverter<?, ?> var2);

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append("[").append(this.id).append("] destination=").append(this.destination).append("' | group='").append(this.group).append("'");
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setConcurrency(String concurrency) {
        this.concurrency = concurrency;
    }

    public String getConcurrency() {
        return this.concurrency;
    }

    private void setupMessageListener(MessageListenerContainer listenerContainer, AzureMessageConverter<?, ?> converter) {
        MessagingMessageListenerAdapter messageListenerAdapter = this.createMessageListener(listenerContainer, converter);
        listenerContainer.setupMessageListener((MessageListener)messageListenerAdapter);
    }
}

