/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusClientCommonProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

abstract class AbstractServiceBusSubClientBuilderFactory<T, P extends ServiceBusClientCommonProperties>
extends AbstractAzureAmqpClientBuilderFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceBusSubClientBuilderFactory.class);
    protected final P properties;
    private ServiceBusClientBuilder serviceBusClientBuilder;
    private final boolean shareServiceBusClientBuilder;
    private ServiceBusClientBuilderFactory serviceBusClientBuilderFactory;

    AbstractServiceBusSubClientBuilderFactory(P properties, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> serviceClientBuilderCustomizers) {
        this(null, properties, serviceClientBuilderCustomizers);
    }

    AbstractServiceBusSubClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, P properties) {
        this(serviceBusClientBuilder, properties, null);
        if (serviceBusClientBuilder == null) {
            LOGGER.debug("The shared ServiceBusClientBuilder instance is null, the {} instance has used a non-shared ServiceBusClientBuilder and ignored the customizers.", (Object)((Object)this).getClass().getSimpleName());
        }
    }

    protected AbstractServiceBusSubClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, P properties, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> serviceBusClientBuilderCustomizers) {
        this.properties = properties;
        if (serviceBusClientBuilder != null) {
            this.serviceBusClientBuilder = serviceBusClientBuilder;
            this.shareServiceBusClientBuilder = true;
            this.serviceBusClientBuilderFactory = null;
        } else {
            this.serviceBusClientBuilderFactory = new ServiceBusClientBuilderFactory((ServiceBusClientCommonProperties)properties);
            if (serviceBusClientBuilderCustomizers != null) {
                serviceBusClientBuilderCustomizers.forEach(arg_0 -> ((ServiceBusClientBuilderFactory)this.serviceBusClientBuilderFactory).addBuilderCustomizer(arg_0));
            }
            this.serviceBusClientBuilder = null;
            this.shareServiceBusClientBuilder = false;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        if (this.serviceBusClientBuilderFactory != null) {
            this.serviceBusClientBuilderFactory.setApplicationContext(applicationContext);
        }
    }

    protected void configureCredential(T builder) {
    }

    protected void configureConnectionString(T builder) {
    }

    protected void configureDefaultCredential(T builder) {
    }

    protected boolean isShareServiceBusClientBuilder() {
        return this.shareServiceBusClientBuilder;
    }

    protected BiConsumer<T, ProxyOptions> consumeProxyOptions() {
        return (builder, proxy) -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().proxyOptions(proxy);
            }
        };
    }

    protected BiConsumer<T, AmqpTransportType> consumeAmqpTransportType() {
        return (builder, t) -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().transportType(t);
            }
        };
    }

    protected BiConsumer<T, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return (builder, retry) -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().retryOptions(retry);
            }
        };
    }

    protected BiConsumer<T, ClientOptions> consumeClientOptions() {
        return (builder, client) -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().clientOptions(client);
            }
        };
    }

    protected AzureProperties getAzureProperties() {
        return this.properties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(T builder) {
        return Arrays.asList(new NamedKeyAuthenticationDescriptor(credential -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().credential(credential);
            }
        }), new SasAuthenticationDescriptor(credential -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().credential(credential);
            }
        }), new TokenAuthenticationDescriptor(this.tokenCredentialResolver, credential -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().credential(credential);
            }
        }));
    }

    protected BiConsumer<T, Configuration> consumeConfiguration() {
        return (builder, configuration) -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().configuration(configuration);
            }
        };
    }

    protected BiConsumer<T, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, credential) -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().credential(credential);
            }
        };
    }

    protected BiConsumer<T, String> consumeConnectionString() {
        return (builder, connectionString) -> {
            if (!this.isShareServiceBusClientBuilder()) {
                this.getServiceBusClientBuilder().connectionString(connectionString);
            }
        };
    }

    protected void configureService(T builder) {
        if (!this.isShareServiceBusClientBuilder()) {
            this.getServiceBusClientBuilder().fullyQualifiedNamespace(this.properties.getFullyQualifiedNamespace());
        }
    }

    protected ServiceBusClientBuilder getServiceBusClientBuilder() {
        if (this.serviceBusClientBuilder == null && this.serviceBusClientBuilderFactory != null) {
            this.serviceBusClientBuilder = (ServiceBusClientBuilder)this.serviceBusClientBuilderFactory.build();
        }
        return this.serviceBusClientBuilder;
    }
}

