/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.factory;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.service.implementation.servicebus.factory.AbstractServiceBusSubClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusProcessorClientProperties;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusErrorHandler;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusRecordMessageListener;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import org.springframework.util.Assert;

public class ServiceBusProcessorClientBuilderFactory
extends AbstractServiceBusSubClientBuilderFactory<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder, ServiceBusProcessorClientProperties> {
    private final ServiceBusProcessorClientProperties processorClientProperties;
    private final MessageListener<?> messageListener;
    private final ServiceBusErrorHandler errorHandler;

    public ServiceBusProcessorClientBuilderFactory(ServiceBusProcessorClientProperties processorClientProperties, MessageListener<?> messageListener, ServiceBusErrorHandler errorHandler) {
        this(null, processorClientProperties, messageListener, errorHandler);
    }

    public ServiceBusProcessorClientBuilderFactory(ServiceBusClientBuilder serviceBusClientBuilder, ServiceBusProcessorClientProperties processorClientProperties, MessageListener<?> messageListener, ServiceBusErrorHandler errorHandler) {
        super(serviceBusClientBuilder, processorClientProperties);
        this.processorClientProperties = processorClientProperties;
        this.messageListener = messageListener;
        this.errorHandler = errorHandler;
    }

    protected ServiceBusClientBuilder.ServiceBusProcessorClientBuilder createBuilderInstance() {
        return this.getServiceBusClientBuilder().processor();
    }

    @Override
    protected void configureService(ServiceBusClientBuilder.ServiceBusProcessorClientBuilder builder) {
        Assert.notNull((Object)((Object)this.processorClientProperties.getEntityType()), (String)"Entity type cannot be null.");
        Assert.notNull((Object)this.processorClientProperties.getEntityName(), (String)"Entity name cannot be null.");
        super.configureService(builder);
        PropertyMapper propertyMapper = new PropertyMapper();
        if (ServiceBusEntityType.TOPIC == this.processorClientProperties.getEntityType()) {
            Assert.notNull((Object)this.processorClientProperties.getSubscriptionName(), (String)"Subscription cannot be null.");
        }
        if (ServiceBusEntityType.QUEUE == this.processorClientProperties.getEntityType()) {
            propertyMapper.from((Object)this.processorClientProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).queueName(arg_0));
        } else if (ServiceBusEntityType.TOPIC == this.processorClientProperties.getEntityType()) {
            propertyMapper.from((Object)this.processorClientProperties.getEntityName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).topicName(arg_0));
            propertyMapper.from((Object)this.processorClientProperties.getSubscriptionName()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).subscriptionName(arg_0));
        }
        propertyMapper.from((Object)this.processorClientProperties.getReceiveMode()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).receiveMode(arg_0));
        propertyMapper.from((Object)this.processorClientProperties.getSubQueue()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).subQueue(arg_0));
        propertyMapper.from((Object)this.processorClientProperties.getPrefetchCount()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).prefetchCount(arg_0));
        propertyMapper.from((Object)this.processorClientProperties.getMaxAutoLockRenewDuration()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).maxAutoLockRenewDuration(arg_0));
        propertyMapper.from((Object)this.processorClientProperties.getAutoComplete()).whenFalse().to(t -> builder.disableAutoComplete());
        propertyMapper.from((Object)this.processorClientProperties.getMaxConcurrentCalls()).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).maxConcurrentCalls(arg_0));
        propertyMapper.from((Object)this.errorHandler).to(arg_0 -> ((ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builder).processError(arg_0));
        this.configureMessageListener(builder);
    }

    private void configureMessageListener(ServiceBusClientBuilder.ServiceBusProcessorClientBuilder builder) {
        if (!(this.messageListener instanceof ServiceBusRecordMessageListener)) {
            throw new IllegalArgumentException("Listener must be a '" + ServiceBusRecordMessageListener.class.getSimpleName() + "' not " + this.messageListener.getClass().getName());
        }
        builder.processMessage(((ServiceBusRecordMessageListener)this.messageListener)::onMessage);
    }
}

