/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.passwordless;

import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.azure.spring.cloud.core.properties.authentication.TokenCredentialProperties;
import com.azure.spring.cloud.core.properties.profile.AzureProfileProperties;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import java.util.HashMap;
import java.util.Map;

public class AzureRedisPasswordlessProperties
implements PasswordlessProperties {
    private static final String REDIS_SCOPE_AZURE = "https://redis.azure.com/.default";
    private static final String REDIS_SCOPE_AZURE_CHINA = "https://*.cacheinfra.windows.net.china:10225/appid/.default";
    @Deprecated
    static final String REDIS_SCOPE_AZURE_GERMANY = "https://*.cacheinfra.windows.net.germany:10225/appid/.default";
    private static final String REDIS_SCOPE_AZURE_US_GOVERNMENT = "https://*.cacheinfra.windows.us.government.net:10225/appid/.default";
    private static final Map<AzureProfileOptionsProvider.CloudType, String> REDIS_SCOPE_MAP = new HashMap<AzureProfileOptionsProvider.CloudType, String>(){
        {
            this.put(AzureProfileOptionsProvider.CloudType.AZURE, AzureRedisPasswordlessProperties.REDIS_SCOPE_AZURE);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_CHINA, AzureRedisPasswordlessProperties.REDIS_SCOPE_AZURE_CHINA);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_US_GOVERNMENT, AzureRedisPasswordlessProperties.REDIS_SCOPE_AZURE_US_GOVERNMENT);
        }
    };
    private AzureProfileProperties profile = new AzureProfileProperties();
    private String scopes;
    private boolean passwordlessEnabled = false;
    private TokenCredentialProperties credential = new TokenCredentialProperties();

    public String getScopes() {
        return this.scopes == null ? this.getDefaultScopes() : this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public boolean isPasswordlessEnabled() {
        return this.passwordlessEnabled;
    }

    public void setPasswordlessEnabled(boolean passwordlessEnabled) {
        this.passwordlessEnabled = passwordlessEnabled;
    }

    private String getDefaultScopes() {
        return REDIS_SCOPE_MAP.getOrDefault(this.getProfile().getCloudType(), REDIS_SCOPE_AZURE);
    }

    public AzureProfileProperties getProfile() {
        return this.profile;
    }

    public void setProfile(AzureProfileProperties profile) {
        this.profile = profile;
    }

    public TokenCredentialProperties getCredential() {
        return this.credential;
    }

    public void setCredential(TokenCredentialProperties credential) {
        this.credential = credential;
    }
}

