/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation;

import com.azure.spring.cloud.feature.management.models.FeatureDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="feature-management")
public class FeatureManagementProperties {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="feature-flags")
    private List<FeatureDefinition> featureFlags;

    public List<FeatureDefinition> getFeatureFlags() {
        return this.featureFlags;
    }

    public void setFeatureFlags(List<FeatureDefinition> featureFlags) {
        if (featureFlags == null || featureFlags.isEmpty()) {
            this.featureFlags = List.of();
            return;
        }
        if (featureFlags.get(0) instanceof FeatureDefinition) {
            ArrayList<FeatureDefinition> features = new ArrayList<FeatureDefinition>();
            for (FeatureDefinition flag : featureFlags) {
                if (!(flag instanceof FeatureDefinition)) continue;
                features.add(flag);
            }
            if (!features.isEmpty()) {
                this.featureFlags = features;
                return;
            }
        }
        ArrayList<FeatureDefinition> convertedFlags = new ArrayList<FeatureDefinition>();
        for (FeatureDefinition feature : featureFlags) {
            FeatureDefinition convertedFeature = (FeatureDefinition)OBJECT_MAPPER.convertValue((Object)feature, FeatureDefinition.class);
            convertedFlags.add(convertedFeature);
        }
        this.featureFlags = convertedFlags;
    }
}

