/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.implementation.models;

import com.azure.spring.cloud.feature.management.implementation.models.RecurrenceRangeType;
import com.azure.spring.cloud.feature.management.implementation.timewindow.TimeWindowUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.ZonedDateTime;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RecurrenceRange {
    private RecurrenceRangeType type = RecurrenceRangeType.NOEND;
    private ZonedDateTime endDate;
    private int numberOfOccurrences;

    public RecurrenceRangeType getType() {
        return this.type;
    }

    public void setType(String type) throws IllegalArgumentException {
        try {
            this.type = RecurrenceRangeType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("The value of parameter %s should be one of [%s].", "Recurrence.Range.Type", Arrays.toString((Object[])RecurrenceRangeType.values())));
        }
    }

    public ZonedDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = TimeWindowUtils.convertStringToDate(endDate);
    }

    public int getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public void setNumberOfOccurrences(int numberOfOccurrences) throws IllegalArgumentException {
        if (numberOfOccurrences < 1) {
            throw new IllegalArgumentException(String.format("The value of parameter %s is out of the accepted range.", "Recurrence.Range.NumberOfOccurrences"));
        }
        this.numberOfOccurrences = numberOfOccurrences;
    }
}

