/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.web;

import com.azure.spring.cloud.feature.management.FeatureManager;
import java.util.HashMap;
import reactor.core.publisher.Mono;

public class FeatureManagerSnapshot {
    private final FeatureManager featureManager;
    private final HashMap<String, Boolean> requestMap;

    public FeatureManagerSnapshot(FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.requestMap = new HashMap();
    }

    public Mono<Boolean> isEnabledAsync(String feature) {
        Boolean featureValue = this.requestMap.get(feature);
        if (featureValue != null) {
            return Mono.just((Object)featureValue);
        }
        return this.featureManager.isEnabledAsync(feature).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled));
    }

    public Boolean isEnabled(String feature) {
        Boolean featureValue = this.requestMap.get(feature);
        if (featureValue != null) {
            return featureValue;
        }
        return (Boolean)this.featureManager.isEnabledAsync(feature).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled)).block();
    }
}

