/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.management.web;

import com.azure.spring.cloud.feature.management.FeatureManager;
import com.azure.spring.cloud.feature.management.web.DisabledFeaturesHandler;
import com.azure.spring.cloud.feature.management.web.FeatureGate;
import com.azure.spring.cloud.feature.management.web.FeatureManagerSnapshot;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import reactor.core.publisher.Mono;

public class FeatureHandler
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureHandler.class);
    private final FeatureManager featureManager;
    private final FeatureManagerSnapshot featureManagerSnapshot;
    private final DisabledFeaturesHandler disabledFeaturesHandler;

    public FeatureHandler(FeatureManager featureManager, FeatureManagerSnapshot featureManagerSnapshot, DisabledFeaturesHandler disabledFeaturesHandler) {
        this.featureManager = featureManager;
        this.featureManagerSnapshot = featureManagerSnapshot;
        this.disabledFeaturesHandler = disabledFeaturesHandler;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        FeatureGate featureOn;
        Method method = null;
        if (handler instanceof HandlerMethod) {
            method = ((HandlerMethod)handler).getMethod();
        }
        if (method != null && (featureOn = method.getAnnotation(FeatureGate.class)) != null) {
            String feature = featureOn.feature();
            boolean snapshot = featureOn.snapshot();
            Mono<Boolean> enabled = !snapshot ? this.featureManager.isEnabledAsync(feature) : this.featureManagerSnapshot.isEnabledAsync(feature);
            boolean isEnabled = false;
            try {
                isEnabled = Optional.ofNullable(enabled).map(Mono::block).orElse(false);
                if (!isEnabled && !featureOn.fallback().isEmpty()) {
                    response.sendRedirect(featureOn.fallback());
                    return false;
                }
            }
            catch (IOException e) {
                LOGGER.info("Unable to send redirect.");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            if (!isEnabled && this.disabledFeaturesHandler != null) {
                this.disabledFeaturesHandler.handleDisabledFeatures(request, response);
            } else if (!isEnabled) {
                try {
                    response.sendError(404);
                }
                catch (IOException e) {
                    LOGGER.error("Error thrown while returning 404 on false feature.", (Throwable)e);
                    return false;
                }
            }
            return isEnabled;
        }
        return true;
    }
}

