/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.util;

import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import org.springframework.beans.BeanUtils;

public final class AzurePasswordlessPropertiesUtils {
    private AzurePasswordlessPropertiesUtils() {
    }

    public static <T extends PasswordlessProperties> void copyAzureCommonProperties(AzureProperties source, T target) {
        BeanUtils.copyProperties((Object)source.getProfile(), (Object)target.getProfile());
        BeanUtils.copyProperties((Object)source.getProfile().getEnvironment(), (Object)target.getProfile().getEnvironment());
        BeanUtils.copyProperties((Object)source.getCredential(), (Object)target.getCredential());
    }

    public static <T extends PasswordlessProperties> void copyAzureCommonPropertiesIgnoreNull(PasswordlessProperties source, T target) {
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getProfile(), target.getProfile());
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getProfile().getEnvironment(), target.getProfile().getEnvironment());
        AzurePropertiesUtils.copyPropertiesIgnoreNull(source.getCredential(), target.getCredential());
        target.setScopes(source.getScopes());
        target.setPasswordlessEnabled(source.isPasswordlessEnabled());
    }

    public static <T extends PasswordlessProperties> void mergeAzureCommonProperties(AzureProperties defaultProperties, PasswordlessProperties properties, T target) {
        AzurePasswordlessPropertiesUtils.copyAzureCommonProperties(defaultProperties, target);
        AzurePasswordlessPropertiesUtils.copyAzureCommonPropertiesIgnoreNull(properties, target);
    }
}

