/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.credential;

import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.properties.AzureProperties;
import java.util.Comparator;
import java.util.List;

public final class AzureCredentialResolvers {
    private final List<AzureCredentialResolver<?>> resolvers;

    public AzureCredentialResolvers(List<AzureCredentialResolver<?>> resolvers) {
        this.resolvers = resolvers;
    }

    public AzureCredentialResolvers(List<AzureCredentialResolver<?>> resolvers, Comparator<AzureCredentialResolver<?>> comparator) {
        this(resolvers);
        this.resolvers.sort(comparator);
    }

    public Object resolve(AzureProperties azureProperties) {
        Object credential = null;
        for (AzureCredentialResolver<?> resolver : this.resolvers) {
            if (resolver.isResolvable(azureProperties) && (credential = resolver.resolve(azureProperties)) != null) break;
        }
        return credential;
    }
}

