/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public final class Memoizer {
    private Memoizer() {
    }

    public static <T, R> Function<T, R> memoize(Function<T, R> fn) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.computeIfAbsent(t, fn);
    }

    public static <T, R> Function<T, R> memoize(Map<T, R> map, Function<T, R> fn) {
        return t -> map.computeIfAbsent(t, fn);
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(BiFunction<T, U, R> biFunction) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return (t, u) -> map.computeIfAbsent(Tuples.of((Object)t, (Object)u), k -> biFunction.apply(k.getT1(), k.getT2()));
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(Map<Tuple2<T, U>, R> map, BiFunction<T, U, R> biFunction) {
        return (t, u) -> map.computeIfAbsent(Tuples.of((Object)t, (Object)u), k -> biFunction.apply(k.getT1(), k.getT2()));
    }
}

