/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.util;

import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public final class AzurePasswordlessPropertiesUtils {
    private AzurePasswordlessPropertiesUtils() {
    }

    public static <T extends PasswordlessProperties> void copyAzureCommonProperties(AzureProperties source, T target) {
        BeanUtils.copyProperties((Object)source.getProfile(), (Object)target.getProfile());
        BeanUtils.copyProperties((Object)source.getProfile().getEnvironment(), (Object)target.getProfile().getEnvironment());
        BeanUtils.copyProperties((Object)source.getCredential(), (Object)target.getCredential());
    }

    public static <T extends PasswordlessProperties> void copyAzureCommonPropertiesIgnoreNull(PasswordlessProperties source, T target) {
        AzurePasswordlessPropertiesUtils.copyPropertiesIgnoreNull(source.getProfile(), target.getProfile());
        AzurePasswordlessPropertiesUtils.copyPropertiesIgnoreNull(source.getProfile().getEnvironment(), target.getProfile().getEnvironment());
        AzurePasswordlessPropertiesUtils.copyPropertiesIgnoreNull(source.getCredential(), target.getCredential());
        target.setScopes(source.getScopes());
        target.setPasswordlessEnabled(source.isPasswordlessEnabled());
    }

    public static <T extends PasswordlessProperties> void mergeAzureCommonProperties(AzureProperties defaultProperties, PasswordlessProperties properties, T target) {
        AzurePasswordlessPropertiesUtils.copyAzureCommonProperties(defaultProperties, target);
        AzurePasswordlessPropertiesUtils.copyAzureCommonPropertiesIgnoreNull(properties, target);
    }

    public static void copyPropertiesIgnoreNull(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])AzurePasswordlessPropertiesUtils.findNullPropertyNames(source));
    }

    private static String[] findPropertyNames(Object source, Predicate<Object> predicate) {
        PropertyDescriptor[] pds;
        HashSet<String> emptyNames = new HashSet<String>();
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(source);
        for (PropertyDescriptor pd : pds = beanWrapper.getPropertyDescriptors()) {
            Object srcValue = beanWrapper.getPropertyValue(pd.getName());
            if (!predicate.test(srcValue)) continue;
            emptyNames.add(pd.getName());
        }
        return emptyNames.toArray(new String[0]);
    }

    private static String[] findNullPropertyNames(Object source) {
        return AzurePasswordlessPropertiesUtils.findPropertyNames(source, Objects::isNull);
    }
}

