/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.eventhubs;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventData;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.AzureEventHubsAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.eventhubs.core.DefaultEventHubsNamespaceProcessorFactory;
import com.azure.spring.messaging.eventhubs.core.DefaultEventHubsNamespaceProducerFactory;
import com.azure.spring.messaging.eventhubs.core.EventHubsProcessorFactory;
import com.azure.spring.messaging.eventhubs.core.EventHubsProducerFactory;
import com.azure.spring.messaging.eventhubs.core.EventHubsTemplate;
import com.azure.spring.messaging.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.messaging.eventhubs.core.properties.ProcessorProperties;
import com.azure.spring.messaging.eventhubs.core.properties.ProducerProperties;
import com.azure.spring.messaging.eventhubs.implementation.support.converter.EventHubsMessageConverter;
import com.azure.spring.messaging.implementation.converter.ObjectMapperHolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EventHubsTemplate.class})
@AutoConfigureAfter(value={AzureEventHubsAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.azure.eventhubs.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"connection-string", "namespace"})
@ConditionalOnBean(value={AzureEventHubsProperties.class})
@Import(value={EventHubsTemplateConfiguration.class, ProcessorContainerConfiguration.class})
public class AzureEventHubsMessagingAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureEventHubsMessagingAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    NamespaceProperties eventHubsNamespaceProperties(AzureEventHubsProperties properties, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.EventHubs>> connectionStringProviders) {
        ServiceConnectionStringProvider connectionStringProvider;
        NamespaceProperties namespaceProperties = new NamespaceProperties();
        BeanUtils.copyProperties((Object)properties, (Object)namespaceProperties);
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)properties, (AzureProperties)namespaceProperties);
        if (namespaceProperties.getConnectionString() == null && (connectionStringProvider = (ServiceConnectionStringProvider)connectionStringProviders.getIfAvailable()) != null) {
            namespaceProperties.setConnectionString(connectionStringProvider.getConnectionString());
            LOGGER.info("Event Hubs connection string is set from {} now.", (Object)connectionStringProvider.getClass().getName());
        }
        return namespaceProperties;
    }

    @Configuration(proxyBeanMethods=false)
    static class EventHubsTemplateConfiguration {
        EventHubsTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        EventHubsProducerFactory defaultEventHubsNamespaceProducerFactory(NamespaceProperties properties, ApplicationContext applicationContext, ObjectProvider<PropertiesSupplier<String, ProducerProperties>> suppliers, ObjectProvider<AzureTokenCredentialResolver> tokenCredentialResolvers, @Qualifier(value="springCloudAzureDefaultCredential") ObjectProvider<TokenCredential> defaultTokenCredentials) {
            DefaultEventHubsNamespaceProducerFactory factory = new DefaultEventHubsNamespaceProducerFactory(properties, (PropertiesSupplier)suppliers.getIfAvailable());
            factory.setApplicationContext(applicationContext);
            factory.setDefaultCredential((TokenCredential)defaultTokenCredentials.getIfAvailable());
            factory.setTokenCredentialResolver((AzureCredentialResolver)tokenCredentialResolvers.getIfAvailable());
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.azure.message-converter.isolated-object-mapper"}, havingValue="true", matchIfMissing=true)
        AzureMessageConverter<EventData, EventData> defaultEventHubsMessageConverter() {
            return new EventHubsMessageConverter(ObjectMapperHolder.OBJECT_MAPPER);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.azure.message-converter.isolated-object-mapper"}, havingValue="false")
        AzureMessageConverter<EventData, EventData> eventHubsMessageConverter(ObjectMapper objectMapper) {
            return new EventHubsMessageConverter(objectMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        EventHubsTemplate eventHubsTemplate(EventHubsProducerFactory producerFactory, AzureMessageConverter<EventData, EventData> messageConverter) {
            EventHubsTemplate eventHubsTemplate = new EventHubsTemplate(producerFactory);
            eventHubsTemplate.setMessageConverter(messageConverter);
            return eventHubsTemplate;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CheckpointStore.class})
    static class ProcessorContainerConfiguration {
        ProcessorContainerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        EventHubsProcessorFactory defaultEventHubsNamespaceProcessorFactory(NamespaceProperties properties, ApplicationContext applicationContext, CheckpointStore checkpointStore, ObjectProvider<PropertiesSupplier<ConsumerIdentifier, ProcessorProperties>> suppliers, ObjectProvider<AzureTokenCredentialResolver> tokenCredentialResolvers, @Qualifier(value="springCloudAzureDefaultCredential") ObjectProvider<TokenCredential> defaultTokenCredentials) {
            DefaultEventHubsNamespaceProcessorFactory factory = new DefaultEventHubsNamespaceProcessorFactory(checkpointStore, properties, (PropertiesSupplier)suppliers.getIfAvailable());
            factory.setApplicationContext(applicationContext);
            factory.setDefaultCredential((TokenCredential)defaultTokenCredentials.getIfAvailable());
            factory.setTokenCredentialResolver((AzureCredentialResolver)tokenCredentialResolvers.getIfAvailable());
            return factory;
        }
    }
}

