/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.context;

import com.azure.core.credential.TokenCredential;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureServiceClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.AbstractAzureCredentialBuilderFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;

class AzureServiceClientBuilderFactoryPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private BeanFactory beanFactory;

    AzureServiceClientBuilderFactoryPostProcessor() {
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractAzureCredentialBuilderFactory) {
            return bean;
        }
        if (bean instanceof AbstractAzureServiceClientBuilderFactory && this.beanFactory.containsBean("springCloudAzureDefaultCredential")) {
            AbstractAzureServiceClientBuilderFactory factory = (AbstractAzureServiceClientBuilderFactory)bean;
            factory.setDefaultTokenCredential((TokenCredential)this.beanFactory.getBean("springCloudAzureDefaultCredential"));
            factory.setTokenCredentialResolver((AzureCredentialResolver)this.beanFactory.getBean(AzureTokenCredentialResolver.class));
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

