/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.compatibility;

import java.io.Serializable;
import java.util.Objects;
import org.springframework.core.style.ToStringCreator;

final class VerificationResult
implements Serializable {
    private static final long serialVersionUID = 7175132562403990299L;
    private final String description;
    private final String action;

    private VerificationResult() {
        this.description = "";
        this.action = "";
    }

    private VerificationResult(String errorDescription, String action) {
        this.description = errorDescription;
        this.action = action;
    }

    static VerificationResult compatible() {
        return new VerificationResult();
    }

    static VerificationResult notCompatible(String errorDescription, String action) {
        return new VerificationResult(errorDescription, action);
    }

    String getDescription() {
        return this.description;
    }

    String getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerificationResult)) {
            return false;
        }
        VerificationResult that = (VerificationResult)o;
        return this.description.equals(that.description) && this.action.equals(that.action);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.action);
    }

    public String toString() {
        ToStringCreator toStringCreator = new ToStringCreator((Object)this);
        toStringCreator.append("description", (Object)this.description);
        toStringCreator.append("action", (Object)this.action);
        return toStringCreator.toString();
    }
}

