/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration;

import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.AadRestTemplateCreator;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.AadB2cPropertiesConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.conditions.AadB2cConditions;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AadB2cProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AuthorizationClientProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.AadB2cClientRegistrationRepository;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.AadB2cUrl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.client.ClientCredentialsOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.azure.active-directory.b2c.enabled"}, havingValue="true")
@Conditional(value={AadB2cConditions.ClientRegistrationCondition.class})
@Import(value={AadB2cPropertiesConfiguration.class})
@ConditionalOnClass(value={OAuth2LoginAuthenticationFilter.class})
class AadB2cOAuth2ClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadB2cOAuth2ClientConfiguration.class);
    private final AadB2cProperties properties;
    private final RestTemplateBuilder restTemplateBuilder;

    AadB2cOAuth2ClientConfiguration(AadB2cProperties properties, RestTemplateBuilder restTemplateBuilder) {
        this.properties = properties;
        this.restTemplateBuilder = restTemplateBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientRegistrationRepository clientRegistrationRepository() {
        Stream<ClientRegistration> clientRegistrationStream = this.properties.getUserFlows().entrySet().stream().map(this::buildUserFlowClientRegistration);
        Stream<ClientRegistration> authorizationClientRegistrations = this.properties.getAuthorizationClients().entrySet().stream().map(this::buildClientRegistration);
        List<ClientRegistration> clientRegistrations = Stream.concat(clientRegistrationStream, authorizationClientRegistrations).collect(Collectors.toList());
        return new AadB2cClientRegistrationRepository(this.properties.getLoginFlow(), clientRegistrations);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ClientRegistrationRepository.class})
    OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ClientRegistrationRepository.class})
    OAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    private ClientRegistration buildUserFlowClientRegistration(Map.Entry<String, String> client) {
        return ClientRegistration.withRegistrationId((String)client.getValue()).clientName(client.getKey()).clientId(this.properties.getCredential().getClientId()).clientSecret(this.properties.getCredential().getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.properties.getReplyUrl()).scope(new String[]{this.properties.getCredential().getClientId(), "openid", "offline_access"}).authorizationUri(AadB2cUrl.getAuthorizationUrl(this.properties.getBaseUri())).tokenUri(AadB2cUrl.getTokenUrl(this.properties.getBaseUri(), client.getValue())).jwkSetUri(AadB2cUrl.getJwkSetUrl(this.properties.getBaseUri(), client.getValue())).userNameAttributeName(this.properties.getUserNameAttributeName()).build();
    }

    private ClientRegistration buildClientRegistration(Map.Entry<String, AuthorizationClientProperties> client) {
        AuthorizationGrantType authGrantType = client.getValue().getAuthorizationGrantType();
        if (!AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)authGrantType)) {
            LOGGER.warn("The authorization type of the {} client registration is not supported.", (Object)client.getKey());
        }
        return ClientRegistration.withRegistrationId((String)client.getKey()).clientName(client.getKey()).clientId(this.properties.getCredential().getClientId()).clientSecret(this.properties.getCredential().getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).authorizationGrantType(authGrantType).scope(client.getValue().getScopes()).tokenUri(AadB2cUrl.getAADTokenUrl(this.properties.getProfile().getTenantId())).jwkSetUri(AadB2cUrl.getAADJwkSetUrl(this.properties.getProfile().getTenantId())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clients, OAuth2AuthorizedClientRepository authorizedClients) {
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().provider((OAuth2AuthorizedClientProvider)this.azureRefreshTokenProvider()).provider((OAuth2AuthorizedClientProvider)this.azureClientCredentialProvider()).build();
        DefaultOAuth2AuthorizedClientManager manager = new DefaultOAuth2AuthorizedClientManager(clients, authorizedClients);
        manager.setAuthorizedClientProvider(authorizedClientProvider);
        return manager;
    }

    private RefreshTokenOAuth2AuthorizedClientProvider azureRefreshTokenProvider() {
        RefreshTokenOAuth2AuthorizedClientProvider provider = new RefreshTokenOAuth2AuthorizedClientProvider();
        RestClientRefreshTokenTokenResponseClient responseClient = new RestClientRefreshTokenTokenResponseClient();
        responseClient.setRestClient(RestClient.create((RestTemplate)AadRestTemplateCreator.createOAuth2AccessTokenResponseClientRestTemplate(this.restTemplateBuilder)));
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }

    private ClientCredentialsOAuth2AuthorizedClientProvider azureClientCredentialProvider() {
        ClientCredentialsOAuth2AuthorizedClientProvider provider = new ClientCredentialsOAuth2AuthorizedClientProvider();
        RestClientClientCredentialsTokenResponseClient responseClient = new RestClientClientCredentialsTokenResponseClient();
        responseClient.setRestClient(RestClient.create((RestTemplate)AadRestTemplateCreator.createOAuth2AccessTokenResponseClientRestTemplate(this.restTemplateBuilder)));
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        return provider;
    }
}

