/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security.jose;

import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.AadRestTemplateCreator;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;

public class RestOperationsResourceRetriever
implements ResourceRetriever {
    private static final MediaType APPLICATION_JWK_SET_JSON = new MediaType("application", "jwk-set+json");
    private final RestOperations restOperations;

    public RestOperationsResourceRetriever(RestTemplateBuilder restTemplateBuilder) {
        this.restOperations = AadRestTemplateCreator.createRestTemplate(restTemplateBuilder);
    }

    public Resource retrieveResource(URL url) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON, APPLICATION_JWK_SET_JSON));
        ResponseEntity<String> response = this.getResponse(url, headers);
        if (response.getStatusCode().isError()) {
            throw new IOException(response.toString());
        }
        return new Resource((String)response.getBody(), "UTF-8");
    }

    private ResponseEntity<String> getResponse(URL url, HttpHeaders headers) throws IOException {
        try {
            RequestEntity request = new RequestEntity(headers, HttpMethod.GET, url.toURI());
            return this.restOperations.exchange(request, String.class);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

