/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadResourceServerProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadJwtGrantedAuthoritiesConverter;
import java.util.Collection;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AadResourceServerHttpSecurityConfigurer
extends AbstractHttpConfigurer<AadResourceServerHttpSecurityConfigurer, HttpSecurity> {
    private AadResourceServerProperties properties;
    private Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter;

    public void init(HttpSecurity builder) {
        try {
            super.init((SecurityBuilder)builder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize AadResourceServerHttpSecurityConfigurer", e);
        }
        ApplicationContext context = (ApplicationContext)builder.getSharedObject(ApplicationContext.class);
        this.properties = (AadResourceServerProperties)context.getBean(AadResourceServerProperties.class);
        builder.oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter(this.jwtAuthenticationConverter())));
    }

    public static AadResourceServerHttpSecurityConfigurer aadResourceServer() {
        return new AadResourceServerHttpSecurityConfigurer();
    }

    private Converter<Jwt, AbstractAuthenticationToken> jwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        if (StringUtils.hasText((String)this.properties.getPrincipalClaimName())) {
            converter.setPrincipalClaimName(this.properties.getPrincipalClaimName());
        }
        if (this.jwtGrantedAuthoritiesConverter != null) {
            converter.setJwtGrantedAuthoritiesConverter(this.jwtGrantedAuthoritiesConverter);
        } else {
            converter.setJwtGrantedAuthoritiesConverter((Converter)new AadJwtGrantedAuthoritiesConverter(this.properties.getClaimToAuthorityPrefixMap()));
        }
        return converter;
    }

    public AadResourceServerHttpSecurityConfigurer jwtGrantedAuthoritiesConverter(Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter) {
        Assert.notNull(jwtGrantedAuthoritiesConverter, (String)"jwtGrantedAuthoritiesConverter cannot be null");
        this.jwtGrantedAuthoritiesConverter = jwtGrantedAuthoritiesConverter;
        return this;
    }
}

