/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.cosmos.properties;

import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.cosmos.properties.AzureCosmosConnectionDetails;
import com.azure.spring.cloud.autoconfigure.implementation.cosmos.properties.AzureCosmosProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.utils.AzureGlobalPropertiesUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ConnectionDetails.class})
@ConditionalOnBean(value={AzureCosmosConnectionDetails.class})
class ConfigurationWithConnectionDetailsBean {
    private final Environment environment;
    private final AzureGlobalProperties globalProperties;
    private final AzureCosmosConnectionDetails connectionDetails;

    ConfigurationWithConnectionDetailsBean(Environment environment, AzureGlobalProperties globalProperties, AzureCosmosConnectionDetails connectionDetails) {
        this.environment = environment;
        this.globalProperties = globalProperties;
        this.connectionDetails = connectionDetails;
    }

    @Bean
    AzureCosmosProperties azureCosmosProperties() {
        AzureCosmosProperties propertiesLoadFromGlobalProperties = AzureGlobalPropertiesUtils.loadProperties(this.globalProperties, new AzureCosmosProperties());
        BindResult bindResult = Binder.get((Environment)this.environment).bind("spring.cloud.azure.cosmos", Bindable.ofInstance((Object)propertiesLoadFromGlobalProperties));
        AzureCosmosProperties properties = bindResult.isBound() ? (AzureCosmosProperties)bindResult.get() : propertiesLoadFromGlobalProperties;
        properties.setEndpoint(this.connectionDetails.getEndpoint());
        properties.setDatabase(this.connectionDetails.getDatabase());
        properties.setKey(this.connectionDetails.getKey());
        properties.setConnectionMode(this.connectionDetails.getConnectionMode());
        properties.setEndpointDiscoveryEnabled(this.connectionDetails.getEndpointDiscoveryEnabled());
        return properties;
    }
}

