/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.storage.queue.properties;

import com.azure.spring.cloud.autoconfigure.implementation.properties.utils.AzureServicePropertiesUtils;
import com.azure.spring.cloud.autoconfigure.implementation.storage.common.AzureStorageProperties;
import com.azure.spring.cloud.autoconfigure.implementation.storage.queue.properties.AzureStorageQueueConnectionDetails;
import com.azure.spring.cloud.autoconfigure.implementation.storage.queue.properties.AzureStorageQueueProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ConnectionDetails.class})
@ConditionalOnBean(value={AzureStorageQueueConnectionDetails.class})
class ConfigurationWithConnectionDetailsBean {
    private final Environment environment;
    private final AzureStorageQueueConnectionDetails connectionDetails;

    ConfigurationWithConnectionDetailsBean(Environment environment, AzureStorageQueueConnectionDetails connectionDetails) {
        this.environment = environment;
        this.connectionDetails = connectionDetails;
    }

    @Bean
    AzureStorageQueueProperties azureStorageQueueProperties(@Qualifier(value="azureStorageProperties") AzureStorageProperties azureStorageProperties) {
        AzureStorageQueueProperties propertiesLoadFromServiceCommonProperties = AzureServicePropertiesUtils.loadServiceCommonProperties(azureStorageProperties, new AzureStorageQueueProperties());
        BindResult bindResult = Binder.get((Environment)this.environment).bind("spring.cloud.azure.storage.queue", Bindable.ofInstance((Object)propertiesLoadFromServiceCommonProperties));
        AzureStorageQueueProperties properties = bindResult.isBound() ? (AzureStorageQueueProperties)bindResult.get() : propertiesLoadFromServiceCommonProperties;
        properties.setConnectionString(this.connectionDetails.getConnectionString());
        properties.setEndpoint(this.connectionDetails.getEndpoint());
        return properties;
    }
}

