/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.keyvault.environment;

import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.environment.KeyVaultOperation;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.lang.NonNull;

public class KeyVaultPropertySource
extends EnumerablePropertySource<KeyVaultOperation> {
    private Map<String, String> properties = new HashMap<String, String>();
    private final KeyVaultOperation keyVaultOperation;
    private final boolean caseSensitive;
    private final List<String> secretKeys;
    private final List<String> keyVaultSecretKeys;
    private static final ConcurrentHashMap<String, Timer> TIMER_MANAGER = new ConcurrentHashMap();

    public KeyVaultPropertySource(String name, Duration refreshDuration, KeyVaultOperation keyVaultOperation, List<String> secretKeys, boolean caseSensitive) {
        super(name, (Object)keyVaultOperation);
        this.caseSensitive = caseSensitive;
        this.secretKeys = secretKeys;
        this.keyVaultSecretKeys = KeyVaultPropertySource.convertToKeyVaultSecretNames(secretKeys, caseSensitive);
        this.keyVaultOperation = keyVaultOperation;
        this.loadProperties();
        this.enablePropertiesAutoRefresh(refreshDuration);
    }

    void loadProperties() {
        this.logger.debug((Object)("Loading the secrets in property source '" + this.name + "'."));
        this.properties = this.keyVaultOperation.listSecrets(this.keyVaultSecretKeys).stream().collect(Collectors.toMap(s -> KeyVaultPropertySource.toKeyVaultSecretName(this.caseSensitive, s.getName()), KeyVaultSecret::getValue));
        this.logger.debug((Object)("The secrets loading in property source '" + this.name + "' has finished."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void enablePropertiesAutoRefresh(Duration refreshDuration) {
        long refreshInMillis = refreshDuration.toMillis();
        if (refreshInMillis <= 0L) return;
        Class<KeyVaultPropertySource> clazz = KeyVaultPropertySource.class;
        synchronized (KeyVaultPropertySource.class) {
            Timer timer;
            if (TIMER_MANAGER.containsKey(this.name)) {
                timer = TIMER_MANAGER.get(this.name);
                try {
                    timer.cancel();
                    timer.purge();
                }
                catch (RuntimeException runtimeException) {
                    this.logger.error((Object)"Error of terminating Timer", (Throwable)runtimeException);
                }
            }
            timer = new Timer(this.name, true);
            TIMER_MANAGER.put(this.name, timer);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    KeyVaultPropertySource.this.loadProperties();
                }
            };
            timer.scheduleAtFixedRate(task, refreshInMillis, refreshInMillis);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public String getProperty(String property) {
        return this.properties.get(KeyVaultPropertySource.toKeyVaultSecretName(this.caseSensitive, property));
    }

    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    public String[] getPropertyNames() {
        if (!this.caseSensitive) {
            return (String[])this.properties.keySet().stream().flatMap(p -> Stream.of(p, p.replace("-", "."))).distinct().toArray(String[]::new);
        }
        return this.properties.keySet().toArray(new String[0]);
    }

    private static List<String> convertToKeyVaultSecretNames(List<String> secretKeys, boolean caseSensitive) {
        if (secretKeys == null) {
            return null;
        }
        return secretKeys.stream().map(key -> KeyVaultPropertySource.toKeyVaultSecretName(caseSensitive, key)).toList();
    }

    public static String toKeyVaultSecretName(boolean caseSensitive, @NonNull String property) {
        if (!caseSensitive) {
            if (property.matches("[a-z0-9A-Z-]+")) {
                return property.toLowerCase(Locale.US);
            }
            if (property.matches("[A-Z0-9_]+")) {
                return property.toLowerCase(Locale.US).replace("_", "-");
            }
            return property.toLowerCase(Locale.US).replace("-", "").replace("_", "").replace(".", "-");
        }
        return property;
    }
}

