/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import com.azure.spring.cloud.autoconfigure.implementation.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.util.StringUtils;

class AzureServiceBusJmsPropertiesBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    AzureServiceBusJmsPropertiesBeanPostProcessor() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        AzureServiceBusJmsProperties jmsProperties;
        if (bean instanceof AzureServiceBusJmsProperties && !StringUtils.hasText((String)(jmsProperties = (AzureServiceBusJmsProperties)bean).getConnectionString())) {
            ResolvableType providerType = ResolvableType.forClassWithGenerics(ServiceConnectionStringProvider.class, (Class[])new Class[]{AzureServiceType.ServiceBus.class});
            ObjectProvider connectionStringProviders = this.applicationContext.getBeanProvider(providerType);
            connectionStringProviders.ifAvailable(provider -> jmsProperties.setConnectionString(provider.getConnectionString()));
        }
        return bean;
    }
}

