/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.redis;

import com.azure.spring.cloud.autoconfigure.redis.AzureJedisPasswordlessAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.redis.RedisUrlSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

final class AzureJedisPasswordlessUtil {
    private static final int AZURE_REDIS_PORT = 6380;
    private static final boolean COMMONS_POOL2_AVAILABLE = ClassUtils.isPresent((String)"org.apache.commons.pool2.ObjectPool", (ClassLoader)AzureJedisPasswordlessAutoConfiguration.class.getClassLoader());

    private AzureJedisPasswordlessUtil() {
    }

    static JedisClientConfiguration getJedisClientConfiguration(RedisProperties redisProperties) {
        JedisClientConfiguration.JedisClientConfigurationBuilder builder = AzureJedisPasswordlessUtil.applyProperties(redisProperties, JedisClientConfiguration.builder());
        RedisProperties.Pool pool = redisProperties.getJedis().getPool();
        if (AzureJedisPasswordlessUtil.isPoolEnabled(pool)) {
            AzureJedisPasswordlessUtil.applyPooling(pool, builder);
        }
        if (StringUtils.hasText((String)redisProperties.getUrl())) {
            AzureJedisPasswordlessUtil.customizeConfigurationFromUrl(redisProperties, builder);
        }
        return builder.build();
    }

    private static JedisClientConfiguration.JedisClientConfigurationBuilder applyProperties(RedisProperties properties, JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from((Object)properties.isSsl()).whenTrue().toCall(() -> ((JedisClientConfiguration.JedisClientConfigurationBuilder)builder).useSsl());
        map.from((Object)properties.getTimeout()).to(arg_0 -> ((JedisClientConfiguration.JedisClientConfigurationBuilder)builder).readTimeout(arg_0));
        map.from((Object)properties.getConnectTimeout()).to(arg_0 -> ((JedisClientConfiguration.JedisClientConfigurationBuilder)builder).connectTimeout(arg_0));
        map.from((Object)properties.getClientName()).whenHasText().to(arg_0 -> ((JedisClientConfiguration.JedisClientConfigurationBuilder)builder).clientName(arg_0));
        return builder;
    }

    private static void customizeConfigurationFromUrl(RedisProperties redisProperties, JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        ConnectionInfo connectionInfo = AzureJedisPasswordlessUtil.parseUrl(redisProperties.getUrl());
        if (connectionInfo.isUseSsl()) {
            builder.useSsl();
        }
    }

    private static boolean isPoolEnabled(RedisProperties.Pool pool) {
        if (pool == null) {
            return false;
        }
        Boolean enabled = true;
        Method method = ReflectionUtils.findMethod(RedisProperties.Pool.class, (String)"getEnabled");
        if (method != null) {
            try {
                enabled = (Boolean)method.invoke((Object)pool, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return enabled != null ? enabled : COMMONS_POOL2_AVAILABLE;
    }

    private static void applyPooling(RedisProperties.Pool pool, JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        builder.usePooling().poolConfig((GenericObjectPoolConfig)AzureJedisPasswordlessUtil.jedisPoolConfig(pool));
    }

    private static JedisPoolConfig jedisPoolConfig(RedisProperties.Pool pool) {
        Method method;
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(pool.getMaxActive());
        config.setMaxIdle(pool.getMaxIdle());
        config.setMinIdle(pool.getMinIdle());
        if (pool.getTimeBetweenEvictionRuns() != null) {
            method = ReflectionUtils.findMethod(RedisProperties.Pool.class, (String)"setTimeBetweenEvictionRuns");
            if (method != null) {
                try {
                    method.invoke((Object)pool, pool.getTimeBetweenEvictionRuns());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else {
                config.setTimeBetweenEvictionRunsMillis(pool.getTimeBetweenEvictionRuns().toMillis());
            }
        }
        if (pool.getMaxWait() != null) {
            method = ReflectionUtils.findMethod(RedisProperties.Pool.class, (String)"setMaxWait");
            if (method != null) {
                try {
                    method.invoke((Object)pool, pool.getMaxWait());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else {
                config.setMaxWaitMillis(pool.getMaxWait().toMillis());
            }
        }
        return config;
    }

    static RedisStandaloneConfiguration getStandaloneConfig(RedisProperties redisProperties) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        if (StringUtils.hasText((String)redisProperties.getUrl())) {
            ConnectionInfo connectionInfo = AzureJedisPasswordlessUtil.parseUrl(redisProperties.getUrl());
            config.setHostName(connectionInfo.getHostName());
            config.setPort(connectionInfo.getPort());
            config.setUsername(connectionInfo.getUsername());
            config.setPassword(RedisPassword.of((String)connectionInfo.getPassword()));
        } else {
            config.setHostName(redisProperties.getHost());
            config.setPort(redisProperties.getPort());
            config.setUsername(redisProperties.getUsername());
            config.setPassword(RedisPassword.of((String)redisProperties.getPassword()));
        }
        config.setDatabase(redisProperties.getDatabase());
        if (config.getPort() == 0) {
            config.setPort(6380);
        }
        return config;
    }

    static ConnectionInfo parseUrl(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (!"redis".equals(scheme) && !"rediss".equals(scheme)) {
                throw new RedisUrlSyntaxException(url);
            }
            boolean useSsl = "rediss".equals(scheme);
            String username = null;
            String password = null;
            if (uri.getUserInfo() != null) {
                String candidate = uri.getUserInfo();
                int index = candidate.indexOf(58);
                if (index >= 0) {
                    username = candidate.substring(0, index);
                    password = candidate.substring(index + 1);
                } else {
                    password = candidate;
                }
            }
            return new ConnectionInfo(uri, useSsl, username, password);
        }
        catch (URISyntaxException ex) {
            throw new RedisUrlSyntaxException(url, ex);
        }
    }

    static class ConnectionInfo {
        private final URI uri;
        private final boolean useSsl;
        private final String username;
        private final String password;

        ConnectionInfo(URI uri, boolean useSsl, String username, String password) {
            this.uri = uri;
            this.useSsl = useSsl;
            this.username = username;
            this.password = password;
        }

        boolean isUseSsl() {
            return this.useSsl;
        }

        String getHostName() {
            return this.uri.getHost();
        }

        int getPort() {
            return this.uri.getPort();
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }
    }
}

