/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhubs;

import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.cloud.service.implementation.eventhubs.factory.EventHubClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubClientCommonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"connection-string", "namespace"})
class AzureEventHubsClientBuilderConfiguration {
    AzureEventHubsClientBuilderConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    EventHubClientBuilder eventHubClientBuilder(@Qualifier(value="springCloudAzureEventHubsClientBuilderFactory") EventHubClientBuilderFactory factory) {
        return (EventHubClientBuilder)factory.build();
    }

    @Bean(value={"springCloudAzureEventHubsClientBuilderFactory"})
    @ConditionalOnMissingBean
    EventHubClientBuilderFactory eventHubClientBuilderFactory(AzureEventHubsProperties properties, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.EventHubs>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> customizers) {
        EventHubClientBuilderFactory factory = new EventHubClientBuilderFactory((EventHubClientCommonProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_EVENT_HUBS);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((EventHubClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((EventHubClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

