/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.condition;

import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.condition.PropertyCondition;
import com.azure.spring.cloud.core.implementation.util.AzureStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class OnMissingPropertyCondition
extends PropertyCondition {
    OnMissingPropertyCondition() {
    }

    @Override
    protected String getAnnotationName() {
        return ConditionalOnMissingProperty.class.getName();
    }

    @Override
    protected ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, PropertyResolver resolver) {
        Spec spec = new Spec(annotationAttributes);
        ArrayList foundProperties = new ArrayList();
        spec.collectProperties(resolver, foundProperties);
        if (!foundProperties.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnMissingProperty.class, (Object[])new Object[]{spec}).found("property", "properties").items(ConditionMessage.Style.QUOTE, foundProperties));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAnyProperty.class, (Object[])new Object[]{spec}).because("matched"));
    }

    private static class Spec {
        private final String prefix;
        private final String[] names;

        Spec(AnnotationAttributes annotationAttributes) {
            String prefixAttr = annotationAttributes.getString("prefix");
            this.prefix = AzureStringUtils.ensureEndsWithSuffix((String)prefixAttr.trim(), (String)".");
            this.names = this.getNames((Map<String, Object>)annotationAttributes);
        }

        private String[] getNames(Map<String, Object> annotationAttributes) {
            String[] value = (String[])annotationAttributes.get("value");
            String[] name = (String[])annotationAttributes.get("name");
            Assert.state((value.length > 0 || name.length > 0 ? 1 : 0) != 0, (String)"The name or value attribute of @ConditionalOnMissingProperty must be specified");
            Assert.state((value.length == 0 || name.length == 0 ? 1 : 0) != 0, (String)"The name and value attributes of @ConditionalOnMissingProperty are exclusive");
            return value.length > 0 ? value : name;
        }

        private void collectProperties(PropertyResolver resolver, List<String> nonMatching) {
            for (String name : this.names) {
                String key = this.prefix + name;
                if (!resolver.containsProperty(key)) continue;
                nonMatching.add(name);
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("(");
            result.append(this.prefix);
            if (this.names.length == 1) {
                result.append(this.names[0]);
            } else {
                result.append("[");
                result.append(StringUtils.arrayToCommaDelimitedString((Object[])this.names));
                result.append("]");
            }
            result.append(")");
            return result.toString();
        }
    }
}

