/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.webapp;

import com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2.AbstractOAuth2AuthorizationCodeGrantRequestEntityConverter;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AadOAuth2AuthorizationCodeGrantRequestEntityConverter
extends AbstractOAuth2AuthorizationCodeGrantRequestEntityConverter {
    private final Set<String> azureClientAccessTokenScopes;

    public AadOAuth2AuthorizationCodeGrantRequestEntityConverter(Set<String> azureClientAccessTokenScopes) {
        this.azureClientAccessTokenScopes = azureClientAccessTokenScopes;
    }

    @Override
    protected String getApplicationId() {
        return "az-sp-aad";
    }

    @Override
    public MultiValueMap<String, String> getHttpBody(OAuth2AuthorizationCodeGrantRequest request) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        String scopes = String.join((CharSequence)" ", this.isRequestForAzureClient(request) ? this.azureClientAccessTokenScopes : request.getClientRegistration().getScopes());
        body.add((Object)"scope", (Object)scopes);
        return body;
    }

    private boolean isRequestForAzureClient(OAuth2AuthorizationCodeGrantRequest request) {
        return Optional.of(request).map(AbstractOAuth2AuthorizationGrantRequest::getClientRegistration).map(ClientRegistration::getRegistrationId).map(id -> id.equals("azure")).orElse(false);
    }
}

