/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2;

import com.azure.spring.cloud.autoconfigure.aad.implementation.jackson.SerializerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;

public class JacksonHttpSessionOAuth2AuthorizedClientRepository
implements OAuth2AuthorizedClientRepository {
    private static final String AUTHORIZED_CLIENTS_ATTR_NAME = JacksonHttpSessionOAuth2AuthorizedClientRepository.class.getName() + ".AUTHORIZED_CLIENTS";
    private static final String MSG_REQUEST_CANNOT_BE_NULL = "request cannot be null";

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.notNull((Object)request, (String)MSG_REQUEST_CANNOT_BE_NULL);
        return (T)this.getAuthorizedClients(request).get(clientRegistrationId);
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)request, (String)MSG_REQUEST_CANNOT_BE_NULL);
        Assert.notNull((Object)response, (String)"response cannot be null");
        HashMap<String, OAuth2AuthorizedClient> authorizedClients = new HashMap<String, OAuth2AuthorizedClient>(this.getAuthorizedClients(request));
        authorizedClients.put(authorizedClient.getClientRegistration().getRegistrationId(), authorizedClient);
        request.getSession().setAttribute(AUTHORIZED_CLIENTS_ATTR_NAME, (Object)SerializerUtils.serializeOAuth2AuthorizedClientMap(authorizedClients));
    }

    public void removeAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.notNull((Object)request, (String)MSG_REQUEST_CANNOT_BE_NULL);
        HashMap<String, OAuth2AuthorizedClient> authorizedClients = new HashMap<String, OAuth2AuthorizedClient>(this.getAuthorizedClients(request));
        if (authorizedClients.remove(clientRegistrationId) != null) {
            if (authorizedClients.isEmpty()) {
                request.getSession().removeAttribute(AUTHORIZED_CLIENTS_ATTR_NAME);
            } else {
                request.getSession().setAttribute(AUTHORIZED_CLIENTS_ATTR_NAME, (Object)SerializerUtils.serializeOAuth2AuthorizedClientMap(authorizedClients));
            }
        }
    }

    private Map<String, OAuth2AuthorizedClient> getAuthorizedClients(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return Optional.ofNullable(session).map(s -> s.getAttribute(AUTHORIZED_CLIENTS_ATTR_NAME)).map(Object::toString).map(SerializerUtils::deserializeOAuth2AuthorizedClientMap).orElse(Collections.emptyMap());
    }
}

