/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.conditions;

import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class ClientCertificatePropertiesCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Azure AD OAuth2 client JWK resolver Condition", (Object[])new Object[0]);
        AzureGlobalProperties globalProperties = (AzureGlobalProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.azure", AzureGlobalProperties.class).orElse(null);
        AadAuthenticationProperties properties = (AadAuthenticationProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.azure.active-directory", AadAuthenticationProperties.class).orElse(null);
        if (globalProperties == null && properties == null) {
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("Azure AD authentication properties"));
        }
        if (globalProperties != null && StringUtils.hasText((String)globalProperties.getCredential().getClientCertificatePath()) && StringUtils.hasText((String)globalProperties.getCredential().getClientCertificatePassword())) {
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"'client-certificate-path' and 'client-certificate-password' under the prefix 'spring.cloud.azure.credential'."));
        }
        if (StringUtils.hasText((String)properties.getCredential().getClientCertificatePath()) && StringUtils.hasText((String)properties.getCredential().getClientCertificatePassword())) {
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"'client-certificate-path' and 'client-certificate-password' under the prefix 'spring.cloud.azure.active-directory.credential'."));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.because("No attribute configuration found for 'client-certificate-path' and 'client-certificate-password'."));
    }
}

