/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.properties;

import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class AppConfigurationKeyValueSelector {
    private static final String[] EMPTY_LABEL_ARRAY = new String[]{"\u0000"};
    private static final String APPLICATION_SETTING_DEFAULT_KEY_FILTER = "/application/";
    private static final String LABEL_SEPARATOR = ",";
    @NotNull
    private String keyFilter = "";
    private String labelFilter;
    private String snapshotName = "";

    public String getKeyFilter() {
        return StringUtils.hasText((String)this.keyFilter) ? this.keyFilter : APPLICATION_SETTING_DEFAULT_KEY_FILTER;
    }

    public AppConfigurationKeyValueSelector setKeyFilter(String keyFilter) {
        this.keyFilter = keyFilter;
        return this;
    }

    public String[] getLabelFilter(List<String> profiles) {
        if (StringUtils.hasText((String)this.snapshotName)) {
            return new String[0];
        }
        if (this.labelFilter == null && !profiles.isEmpty()) {
            ArrayList<String> mutableProfiles = new ArrayList<String>(profiles);
            Collections.reverse(mutableProfiles);
            return mutableProfiles.toArray(new String[mutableProfiles.size()]);
        }
        if (!StringUtils.hasText((String)this.labelFilter)) {
            return EMPTY_LABEL_ARRAY;
        }
        List<String> labels = Arrays.stream(this.labelFilter.split(LABEL_SEPARATOR)).map(this::mapLabel).distinct().collect(Collectors.toList());
        if (this.labelFilter.endsWith(LABEL_SEPARATOR)) {
            labels.add("\u0000");
        }
        Collections.reverse(labels);
        String[] t = new String[labels.size()];
        return labels.toArray(t);
    }

    public AppConfigurationKeyValueSelector setLabelFilter(String labelFilter) {
        this.labelFilter = labelFilter;
        return this;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    @PostConstruct
    void validateAndInit() {
        Assert.isTrue((!this.keyFilter.contains("*") ? 1 : 0) != 0, (String)"KeyFilter must not contain asterisk(*)");
        if (this.labelFilter != null) {
            Assert.isTrue((!this.labelFilter.contains("*") ? 1 : 0) != 0, (String)"LabelFilter must not contain asterisk(*)");
        }
        Assert.isTrue((!StringUtils.hasText((String)this.keyFilter) || !StringUtils.hasText((String)this.snapshotName) ? 1 : 0) != 0, (String)"Snapshots can't use key filters");
        Assert.isTrue((!StringUtils.hasText((String)this.labelFilter) || !StringUtils.hasText((String)this.snapshotName) ? 1 : 0) != 0, (String)"Snapshots can't use label filters");
    }

    private String mapLabel(String label) {
        if (label == null || "".equals(label) || "\u0000".equals(label)) {
            return "\u0000";
        }
        return label.trim();
    }
}

