/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationApplicationSettingPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationFeatureManagementPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;

final class AppConfigurationSnapshotPropertySource
extends AppConfigurationApplicationSettingPropertySource {
    private final String snapshotName;

    AppConfigurationSnapshotPropertySource(String name, AppConfigurationReplicaClient replicaClient, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, String snapshotName) {
        super(name, replicaClient, keyVaultClientFactory, null, null);
        this.snapshotName = snapshotName;
    }

    @Override
    public void initProperties(List<String> trim) throws JsonProcessingException {
        this.processConfigurationSettings(this.replicaClient.listSettingSnapshot(this.snapshotName), null, trim);
    }

    @Override
    void handleFeatureFlag(String key, FeatureFlagConfigurationSetting setting, List<String> trimStrings) throws JsonProcessingException {
        this.processFeatureFlag(key, setting, trimStrings);
    }

    protected void processFeatureFlag(String key, FeatureFlagConfigurationSetting setting, List<String> trimStrings) {
        TracingInfo tracing = this.replicaClient.getTracingInfo();
        this.featureConfigurationSettings.add(setting);
        FeatureFlagConfigurationSetting featureFlag = setting;
        String configName = "feature-management." + setting.getKey().trim().substring(".appconfig.featureflag/".length());
        AppConfigurationFeatureManagementPropertySource.updateTelemetry(featureFlag, tracing);
        this.properties.put(configName, AppConfigurationFeatureManagementPropertySource.createFeature(featureFlag));
    }
}

