/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.web.implementation.pushrefresh;

import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProperties;
import com.azure.spring.cloud.appconfiguration.config.web.implementation.AppConfigurationEndpoint;
import com.azure.spring.cloud.appconfiguration.config.web.implementation.pushrefresh.AppConfigurationRefreshEvent;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerEndpoint(id="appconfiguration-refresh")
public class AppConfigurationRefreshEndpoint
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationRefreshEndpoint.class);
    private final ContextRefresher contextRefresher;
    private final AppConfigurationProperties appConfiguration;
    private ApplicationEventPublisher publisher;

    public AppConfigurationRefreshEndpoint(ContextRefresher contextRefresher, AppConfigurationProperties appConfiguration) {
        this.contextRefresher = contextRefresher;
        this.appConfiguration = appConfiguration;
    }

    @PostMapping(value={"/"})
    @ResponseBody
    public String refresh(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, String> allRequestParams) throws IOException {
        AppConfigurationEndpoint endpoint;
        try {
            endpoint = new AppConfigurationEndpoint(request, this.appConfiguration.getStores(), allRequestParams);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
        }
        String syncToken = endpoint.getSyncToken();
        JsonNode validationResponse = endpoint.getValidationResponse();
        if (validationResponse != null) {
            return String.format("%s%s\"}", "{ \"validationResponse\": \"", validationResponse.asText());
        }
        if (!endpoint.authenticate()) {
            return HttpStatus.UNAUTHORIZED.getReasonPhrase();
        }
        if (this.contextRefresher != null) {
            if (endpoint.triggerRefresh()) {
                this.publisher.publishEvent((ApplicationEvent)new AppConfigurationRefreshEvent(endpoint.getEndpoint(), syncToken));
                return HttpStatus.OK.getReasonPhrase();
            }
            LOGGER.debug("Non Refreshable notification");
            return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
        }
        LOGGER.error("ContextRefresher Not Found. Unable to Refresh.");
        return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

